/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.resources.OptionalDependencies;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeNode
extends Rectangle
implements Iterable<TreeNode>,
javax.swing.tree.TreeNode {
    private static final long serialVersionUID = 1669511478839242773L;
    protected Tile tile;
    private TreeNode parent;
    private TreeNode firstChildren;
    private TreeNode lastChildren;
    private TreeNode previousSibling;
    private TreeNode nextSibling;

    protected TreeNode() {
        super(-1, -1);
    }

    protected TreeNode(Rectangle bounds) {
        super(bounds);
    }

    public void addChild(TreeNode child) throws ClassCastException {
        if (child != null) {
            assert (child.isRoot() && (this.tile == null || this.contains(child))) : child;
            child.parent = this;
            if (this.lastChildren == null) {
                this.lastChildren = this.firstChildren = child;
            } else {
                child.previousSibling = this.lastChildren;
                this.lastChildren.nextSibling = child;
                this.lastChildren = child;
            }
        }
    }

    public void removeChildren() {
        TreeNode child = this.firstChildren;
        while (child != null) {
            assert (child.parent == this);
            TreeNode next = child.nextSibling;
            child.previousSibling = null;
            child.nextSibling = null;
            child.parent = null;
            child = next;
        }
        this.lastChildren = null;
        this.firstChildren = null;
    }

    public void remove() {
        if (this.previousSibling != null) {
            this.previousSibling.nextSibling = this.nextSibling;
        }
        if (this.nextSibling != null) {
            this.nextSibling.previousSibling = this.previousSibling;
        }
        if (this.parent != null) {
            if (this.parent.firstChildren == this) {
                this.parent.firstChildren = this.nextSibling;
            }
            if (this.parent.lastChildren == this) {
                this.parent.lastChildren = this.previousSibling;
            }
            this.parent = null;
        }
        this.previousSibling = null;
        this.nextSibling = null;
    }

    final int getTileCount() {
        int count = this.tile != null ? 1 : 0;
        TreeNode child = this.firstChildren;
        while (child != null) {
            count += child.getTileCount();
            child = child.nextSibling;
        }
        return count;
    }

    public final Tile getUserObject() {
        return this.tile;
    }

    @Override
    public final TreeNode getParent() {
        return this.parent;
    }

    public final boolean isRoot() {
        return this.parent == null && this.previousSibling == null && this.nextSibling == null;
    }

    @Override
    public final boolean isLeaf() {
        assert (this.firstChildren == null == (this.lastChildren == null));
        return this.firstChildren == null;
    }

    @Override
    public final boolean getAllowsChildren() {
        return !super.isEmpty();
    }

    public boolean hasOverlaps() {
        return false;
    }

    public final TreeNode getChild() {
        return this.firstChildren == this.lastChildren ? this.firstChildren : null;
    }

    @Override
    public final int getChildCount() {
        int count = 0;
        TreeNode child = this.firstChildren;
        while (child != null) {
            child = child.nextSibling;
            ++count;
        }
        return count;
    }

    @Override
    public final TreeNode getChildAt(int index) {
        TreeNode child = this.firstChildren;
        while (child != null) {
            if (index == 0) {
                return child;
            }
            child = child.nextSibling;
            --index;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getIndex(javax.swing.tree.TreeNode node) {
        int index = 0;
        TreeNode child = this.firstChildren;
        while (child != null) {
            if (child == node) {
                assert (this.getChildAt(index) == node) : index;
                return index;
            }
            child = child.nextSibling;
            ++index;
        }
        return -1;
    }

    final TreeNode firstChildren() {
        return this.firstChildren;
    }

    final TreeNode nextSibling() {
        return this.nextSibling;
    }

    public final Enumeration<TreeNode> children() {
        return new Iter(this.firstChildren);
    }

    @Override
    public final Iterator<TreeNode> iterator() {
        return new Iter(this.firstChildren);
    }

    public final boolean remove(Tile tile) throws IOException {
        return this.contains(tile.getAbsoluteRegion(), tile, true);
    }

    public final boolean containsAll(Collection<Tile> tiles) throws IOException {
        for (Tile tile : tiles) {
            if (this.contains(tile.getAbsoluteRegion(), tile, false)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(Rectangle region, Tile candidate, boolean remove) {
        if (this.equals(region)) {
            if (remove) {
                this.tile = null;
            }
            return true;
        }
        if (super.contains(region)) {
            TreeNode child = this.firstChildren;
            while (child != null) {
                if (child.contains(region, candidate, remove)) {
                    if (remove && child.tile == null && child.isLeaf()) {
                        child.remove();
                    }
                    return true;
                }
                child = child.nextSibling;
            }
        }
        return false;
    }

    public final Collection<Tile> containedIn(Rectangle roi) {
        LinkedList<Tile> tiles = new LinkedList<Tile>();
        this.containedIn(roi, tiles);
        return tiles;
    }

    private void containedIn(Rectangle roi, Collection<Tile> tiles) {
        if (roi.contains(this)) {
            this.copy(tiles);
        } else if (roi.intersects(this)) {
            TreeNode child = this.firstChildren;
            while (child != null) {
                child.containedIn(roi, tiles);
                child = child.nextSibling;
            }
        }
    }

    private void copy(Collection<Tile> tiles) {
        if (this.tile != null) {
            tiles.add(this.tile);
        }
        TreeNode child = this.firstChildren;
        while (child != null) {
            child.copy(tiles);
            child = child.nextSibling;
        }
    }

    public final Collection<Tile> intersecting(Rectangle roi) {
        LinkedList<Tile> tiles = new LinkedList<Tile>();
        this.intersecting(roi, tiles);
        return tiles;
    }

    private void intersecting(Rectangle roi, Collection<Tile> tiles) {
        if (this.intersects(roi)) {
            if (this.tile != null) {
                tiles.add(this.tile);
            }
            TreeNode child = this.firstChildren;
            while (child != null) {
                child.intersecting(roi, tiles);
                child = child.nextSibling;
            }
        }
    }

    final void getTiles(List<Tile> tiles) {
        if (this.tile != null) {
            tiles.add(this.tile);
        }
        TreeNode child = this.firstChildren;
        while (child != null) {
            child.getTiles(tiles);
            child = child.nextSibling;
        }
    }

    @Override
    public final boolean equals(Object other) {
        return other == this || super.equals(other);
    }

    public final boolean deepEquals(TreeNode other) {
        if (other == this) {
            return true;
        }
        if (!this.equals(other) || !Utilities.equals((Object)this.tile, (Object)other.tile)) {
            return false;
        }
        Iterator<TreeNode> it1 = this.iterator();
        Iterator<TreeNode> it2 = other.iterator();
        if (it1.hasNext()) {
            TreeNode t2;
            if (!it2.hasNext()) {
                return false;
            }
            TreeNode t1 = it1.next();
            return t1 == (t2 = it2.next()) || t1 != null && t1.deepEquals(t2);
        }
        return !it2.hasNext();
    }

    public final String toTree() {
        return OptionalDependencies.toString((javax.swing.tree.TreeNode)this);
    }

    @Override
    public final String toString() {
        String text;
        if (this.tile != null) {
            text = this.tile.toString();
        } else {
            text = super.toString();
            text = text.substring(text.lastIndexOf(46) + 1);
        }
        if (!this.isLeaf()) {
            StringBuilder buffer = new StringBuilder(text).append(" (").append(this.getChildCount()).append(" childs");
            if (this.hasOverlaps()) {
                buffer.append(", overlaps");
            }
            text = buffer.append(')').toString();
        }
        return text;
    }

    boolean checkValidity() {
        TreeNode child = this.firstChildren;
        if (child != null) {
            if (child.previousSibling != null) {
                throw new AssertionError(this);
            }
            if (this.isLeaf() || !this.getAllowsChildren()) {
                throw new AssertionError(this);
            }
            int index = 0;
            while (true) {
                if (child.parent != this) {
                    throw new AssertionError(child);
                }
                if (this.getIndex(child) != index) {
                    throw new AssertionError(child);
                }
                if (!child.checkValidity()) {
                    return false;
                }
                TreeNode next = child.nextSibling;
                if (next == null) break;
                if (next.previousSibling != child) {
                    throw new AssertionError(child);
                }
                if (!this.contains(child) && this.width >= 0 && this.height >= 0) {
                    throw new AssertionError(child);
                }
                child = next;
                ++index;
            }
        }
        if (child != this.lastChildren) {
            throw new AssertionError(this);
        }
        if (this.tile != null) {
            Rectangle bounds;
            if (this.isEmpty()) {
                throw new AssertionError(this);
            }
            try {
                bounds = this.tile.getAbsoluteRegion();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            if (!bounds.contains(this)) {
                throw new AssertionError(this);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Iter
    implements Iterator<TreeNode>,
    Enumeration<TreeNode> {
        private TreeNode children;
        private TreeNode last;

        public Iter(TreeNode first) {
            this.children = first;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.children != null;
        }

        @Override
        public TreeNode next() {
            if (this.children != null) {
                this.last = this.children;
                this.children = this.children.nextSibling;
                return this.last;
            }
            throw new NoSuchElementException();
        }

        @Override
        public TreeNode nextElement() {
            return this.next();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.last.remove();
            this.last = null;
        }
    }
}

