/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.media.jai.iterator.RectIter;
import org.geotools.factory.GeoTools;
import org.geotools.image.ImageDimension;
import org.geotools.image.io.text.TextImageWriter;
import org.geotools.image.io.text.TextMatrixImageReader;
import org.geotools.resources.i18n.Descriptions;
import org.geotools.util.Utilities;

public class TextMatrixImageWriter
extends TextImageWriter {
    private static final int SEPARATOR_WIDTH = 1;

    protected TextMatrixImageWriter(ImageWriterSpi provider) {
        super(provider);
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam parameters) throws IOException {
        this.processImageStarted();
        BufferedWriter out = this.getWriter(parameters);
        String lineSeparator = this.getLineSeparator(parameters);
        NumberFormat format = this.createNumberFormat(image, parameters);
        FieldPosition pos = this.getExpectedFractionPosition(format);
        int fractionWidth = pos.getEndIndex() - pos.getBeginIndex();
        int width = pos.getEndIndex() + 1;
        StringBuffer buffer = new StringBuffer(width);
        RectIter iterator = TextMatrixImageWriter.createRectIter(image, parameters);
        ImageDimension size = TextMatrixImageWriter.computeSize(image, parameters);
        float progressScale = 100.0f / (float)size.getNumSampleValues();
        int numSampleValues = 0;
        int nextProgress = 0;
        if (!iterator.finishedBands()) {
            do {
                if (!iterator.finishedLines()) {
                    do {
                        if (numSampleValues >= nextProgress) {
                            this.processImageProgress(progressScale * (float)numSampleValues);
                            nextProgress = numSampleValues + 2000;
                        }
                        if (!iterator.finishedPixels()) {
                            do {
                                buffer.setLength(0);
                                String n = format.format(iterator.getSampleDouble(), buffer, pos).toString();
                                int fractionOffset = Math.max(0, fractionWidth - (pos.getEndIndex() - pos.getBeginIndex()));
                                out.write(Utilities.spaces((int)(width - n.length() - fractionOffset)));
                                out.write(n);
                                out.write(Utilities.spaces((int)fractionOffset));
                            } while (!iterator.nextPixelDone());
                        }
                        out.write(lineSeparator);
                        numSampleValues += size.width;
                        iterator.startPixels();
                    } while (!iterator.nextLineDone());
                }
                out.write(lineSeparator);
                iterator.startLines();
            } while (!iterator.nextBandDone());
        }
        out.flush();
        this.processImageComplete();
    }

    public static class Spi
    extends TextImageWriter.Spi {
        public Spi() {
            this.names = TextMatrixImageReader.Spi.NAMES;
            this.MIMETypes = TextMatrixImageReader.Spi.MIME_TYPES;
            this.pluginClassName = "org.geotools.image.io.text.TextMatrixImageWriter";
            this.vendorName = "GeoTools";
            this.version = GeoTools.getVersion().toString();
        }

        public String getDescription(Locale locale) {
            return Descriptions.getResources((Locale)locale).getString(1);
        }

        public ImageWriter createWriterInstance(Object extension) throws IOException {
            return new TextMatrixImageWriter(this);
        }
    }
}

