/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.tree.TreeNode;
import org.geotools.image.io.GeographicImageReader;
import org.geotools.image.io.GeographicImageWriter;
import org.geotools.image.io.metadata.Band;
import org.geotools.image.io.metadata.ChildList;
import org.geotools.image.io.metadata.GeographicMetadataFormat;
import org.geotools.image.io.metadata.ImageGeometry;
import org.geotools.image.io.metadata.ImageReferencing;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.resources.OptionalDependencies;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.LoggedFormat;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicMetadata
extends IIOMetadata {
    private final Object owner;
    private Node root;
    private ImageReferencing referencing;
    private ImageGeometry geometry;
    private ChildList<Band> bands;
    private transient LoggedFormat<Date> dateFormat;

    public GeographicMetadata() {
        this((Object)null);
    }

    public GeographicMetadata(ImageReader reader) {
        this((Object)reader);
    }

    public GeographicMetadata(ImageWriter writer) {
        this((Object)writer);
    }

    private GeographicMetadata(Object owner) {
        super(false, null, null, new String[]{"geotools_coverage_1.0"}, new String[]{"org.geotools.image.io.metadata.GeographicMetadataFormat"});
        this.owner = owner;
    }

    public GeographicMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        super(standardMetadataFormatSupported, nativeMetadataFormatName, nativeMetadataFormatClassName, extraMetadataFormatNames, extraMetadataFormatClassNames);
        this.owner = null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    final Node getRootNode() {
        if (this.root == null) {
            this.root = new IIOMetadataNode("geotools_coverage_1.0");
        }
        return this.root;
    }

    public ImageReferencing getReferencing() {
        if (this.referencing == null) {
            this.referencing = new ImageReferencing(this);
        }
        return this.referencing;
    }

    public ImageGeometry getGeometry() {
        if (this.geometry == null) {
            this.geometry = new ImageGeometry(this);
        }
        return this.geometry;
    }

    final ChildList<Band> getBands() {
        if (this.bands == null) {
            this.bands = new ChildList.Bands(this);
        }
        return this.bands;
    }

    public String getSampleType() {
        return this.getBands().getAttributeAsString("type");
    }

    public void setSampleType(String type) {
        this.getBands().setAttributeAsEnum("type", type, GeographicMetadataFormat.SAMPLE_TYPES);
    }

    public int getNumBands() {
        return this.getBands().childCount();
    }

    public Band getBand(int bandIndex) throws IndexOutOfBoundsException {
        return this.getBands().getChild(bandIndex);
    }

    public Band addBand(String name) {
        Band band = this.getBands().addChild();
        band.setName(name);
        return band;
    }

    private void checkFormatName(String formatName) throws IllegalArgumentException {
        if (!"geotools_coverage_1.0".equals(formatName)) {
            throw new IllegalArgumentException(Errors.getResources((Locale)this.getLocale()).getString(42, (Object)"formatName", (Object)formatName));
        }
    }

    @Override
    public Node getAsTree(String formatName) throws IllegalArgumentException {
        this.checkFormatName(formatName);
        return this.getRootNode();
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        this.checkFormatName(formatName);
        this.reset();
        this.root = root;
    }

    public void mergeTree(IIOMetadata metadata) throws IIOInvalidTreeException {
        Node tree;
        try {
            tree = metadata.getAsTree("geotools_coverage_1.0");
        }
        catch (IllegalArgumentException exception) {
            throw new IIOInvalidTreeException(Errors.format((int)166, (Object)"mergeTree"), exception, null);
        }
        this.mergeTree("geotools_coverage_1.0", tree);
    }

    @Override
    public void reset() {
        this.root = null;
        this.referencing = null;
        this.geometry = null;
        this.bands = null;
    }

    public Locale getLocale() {
        if (this.owner instanceof ImageReader) {
            return ((ImageReader)this.owner).getLocale();
        }
        if (this.owner instanceof ImageWriter) {
            return ((ImageWriter)this.owner).getLocale();
        }
        return null;
    }

    protected void warningOccurred(LogRecord record) {
        if (this.owner instanceof GeographicImageReader) {
            ((GeographicImageReader)this.owner).warningOccurred(record);
        } else if (this.owner instanceof GeographicImageWriter) {
            ((GeographicImageWriter)this.owner).warningOccurred(record);
        } else {
            Logger logger = Logging.getLogger(GeographicMetadata.class);
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
    }

    protected <T> LoggedFormat<T> createLoggedFormat(Format format, Class<T> type) {
        return new FormatAdapter<T>(format, type);
    }

    final LoggedFormat<Date> dateFormat() {
        if (this.dateFormat == null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.dateFormat = this.createLoggedFormat(format, Date.class);
            this.dateFormat.setLogger("org.geotools.image.io.metadata");
            this.dateFormat.setCaller(MetadataAccessor.class, "getDate");
        }
        return this.dateFormat;
    }

    public String toString() {
        return OptionalDependencies.toString((TreeNode)OptionalDependencies.xmlToSwing((Node)this.getAsTree("geotools_coverage_1.0")));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FormatAdapter<T>
    extends LoggedFormat<T> {
        private static final long serialVersionUID = -1108933164506428318L;

        FormatAdapter(Format format, Class<T> type) {
            super(format, type);
        }

        protected Locale getWarningLocale() {
            return GeographicMetadata.this.getLocale();
        }

        protected void logWarning(LogRecord warning) {
            GeographicMetadata.this.warningOccurred(warning);
        }
    }
}

