/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.geotools.coverage.grid.ImageGeometry;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Hints;
import org.geotools.image.io.mosaic.ComparedTileManager;
import org.geotools.image.io.mosaic.GridTileManager;
import org.geotools.image.io.mosaic.RegionCalculator;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.image.io.mosaic.TreeTileManager;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileManagerFactory
extends AbstractFactory {
    public static final TileManagerFactory DEFAULT = new TileManagerFactory(null);

    protected TileManagerFactory(Hints hints) {
    }

    public TileManager[] createFromObject(Object tiles) throws IOException, IllegalArgumentException {
        TileManager[] managers;
        if (tiles == null) {
            managers = null;
        } else if (tiles instanceof TileManager[]) {
            managers = (TileManager[])((TileManager[])tiles).clone();
        } else if (tiles instanceof TileManager) {
            managers = new TileManager[]{(TileManager)tiles};
        } else if (tiles instanceof Tile[]) {
            managers = this.create((Tile[])tiles);
        } else if (tiles instanceof Collection) {
            Collection c = (Collection)tiles;
            managers = this.create(c);
        } else {
            throw new IllegalArgumentException(Errors.format((int)45, tiles.getClass(), TileManager.class));
        }
        if (managers != null) {
            for (int i = 0; i < managers.length; ++i) {
                if (managers[i] != null) continue;
                throw new IllegalArgumentException(Errors.format((int)105, (Object)("input[" + i + ']')));
            }
        }
        return managers;
    }

    public TileManager[] create(Tile[] tiles) throws IOException {
        return this.create(Arrays.asList(tiles));
    }

    public TileManager[] create(Collection<Tile> tiles) throws IOException {
        TileManager[] managers;
        int count = 0;
        if (!TileManagerFactory.hasPendingGridToCRS(tiles)) {
            if (!tiles.isEmpty()) {
                count = 1;
            }
            managers = new TileManager[count];
        } else {
            ArrayList<Tile> remainings = new ArrayList<Tile>(Math.min(16, tiles.size()));
            RegionCalculator calculator = new RegionCalculator();
            for (Tile tile : tiles) {
                if (calculator.add(tile)) continue;
                remainings.add(tile);
            }
            if (!remainings.isEmpty()) {
                count = 1;
            }
            Map<ImageGeometry, Tile[]> split = calculator.tiles();
            managers = new TileManager[split.size() + count];
            for (Map.Entry<ImageGeometry, Tile[]> entry : split.entrySet()) {
                TileManager manager = this.createGeneric(entry.getValue());
                manager.geometry = entry.getKey();
                managers[count++] = manager;
            }
            tiles = remainings;
        }
        if (!tiles.isEmpty()) {
            managers[0] = this.createGeneric(tiles.toArray(new Tile[tiles.size()]));
        }
        return managers;
    }

    private static boolean hasPendingGridToCRS(Collection<Tile> tiles) {
        for (Tile tile : tiles) {
            if (tile.getPendingGridToCRS(false) == null) continue;
            return true;
        }
        return false;
    }

    protected TileManager createGeneric(Tile[] tiles) throws IOException {
        TileManager manager;
        try {
            manager = new GridTileManager(tiles);
        }
        catch (IllegalArgumentException e) {
            Logging.recoverableException(TileManagerFactory.class, (String)"createGeneric", (Throwable)e);
            return new TreeTileManager(tiles);
        }
        assert ((manager = new ComparedTileManager(manager, new TreeTileManager(tiles))) != null);
        return manager;
    }
}

