/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.IIOException;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.image.io.ContinuousPalette;
import org.geotools.image.io.IndexedPalette;
import org.geotools.image.io.Palette;
import org.geotools.io.DefaultFileFilter;
import org.geotools.io.LineFormat;
import org.geotools.resources.IndexedResourceBundle;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CanonicalSet;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteFactory {
    private static final String LIST_FILE = "list.txt";
    private static final File DEFAULT_DIRECTORY = new File("colors");
    private static PaletteFactory defaultFactory;
    private PaletteFactory fallback;
    private final ClassLoader classloader;
    private final Class<?> loader;
    private final File directory;
    private final String extension;
    private final Charset charset;
    private final Locale locale;
    private transient ThreadLocal<Locale> warningLocales;
    private final CanonicalSet<Palette> palettes = CanonicalSet.newInstance(Palette.class);
    final Set<Palette> protectedPalettes = new HashSet<Palette>();

    public static synchronized PaletteFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new PaletteFactory();
            PaletteFactory.scanForPlugins(null);
        }
        return defaultFactory;
    }

    public static synchronized void scanForPlugins(ClassLoader loader) {
        Iterator<PaletteFactory> it;
        HashSet existings = new HashSet();
        PaletteFactory p = PaletteFactory.getDefault();
        while (p != null) {
            existings.add(p.getClass());
            p = p.fallback;
        }
        Iterator<PaletteFactory> iterator = it = loader == null ? ServiceRegistry.lookupProviders(PaletteFactory.class) : ServiceRegistry.lookupProviders(PaletteFactory.class, loader);
        while (it.hasNext()) {
            PaletteFactory factory = it.next();
            if (!existings.add(factory.getClass())) continue;
            PaletteFactory tail = factory;
            while (tail.fallback != null) {
                tail = tail.fallback;
            }
            tail.fallback = defaultFactory;
            defaultFactory = factory;
        }
    }

    protected PaletteFactory() {
        this.classloader = null;
        this.loader = this.getClass();
        this.directory = DEFAULT_DIRECTORY;
        this.extension = ".pal";
        this.charset = Charset.forName("ISO-8859-1");
        this.locale = Locale.US;
    }

    public PaletteFactory(File directory, String extension, Charset charset, Locale locale) {
        this.classloader = null;
        this.loader = null;
        this.directory = directory;
        this.extension = PaletteFactory.startWithDot(extension);
        this.charset = charset;
        this.locale = locale;
    }

    public PaletteFactory(PaletteFactory fallback, ClassLoader loader, File directory, String extension, Charset charset, Locale locale) {
        this.fallback = fallback;
        this.classloader = loader;
        this.loader = null;
        this.directory = directory;
        this.extension = PaletteFactory.startWithDot(extension);
        this.charset = charset;
        this.locale = locale;
    }

    public PaletteFactory(PaletteFactory fallback, Class<?> loader, File directory, String extension, Charset charset, Locale locale) {
        this.fallback = fallback;
        this.classloader = null;
        this.loader = loader;
        this.directory = directory;
        this.extension = PaletteFactory.startWithDot(extension);
        this.charset = charset;
        this.locale = locale;
    }

    private static String startWithDot(String extension) {
        if (extension != null && !extension.startsWith(".")) {
            extension = '.' + extension;
        }
        return extension;
    }

    public synchronized void setWarningLocale(Locale warningLocale) {
        if (this.warningLocales == null) {
            if (warningLocale == null) {
                return;
            }
            this.warningLocales = this.warningLocales();
        }
        this.warningLocales.set(warningLocale);
    }

    private synchronized ThreadLocal<Locale> warningLocales() {
        if (this.warningLocales == null) {
            this.warningLocales = this.fallback != null ? this.fallback.warningLocales() : new ThreadLocal<Locale>();
        }
        return this.warningLocales;
    }

    public Locale getWarningLocale() {
        ThreadLocal<Locale> warningLocales = this.warningLocales;
        if (warningLocales != null) {
            return warningLocales.get();
        }
        return null;
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getWarningLocale());
    }

    protected InputStream getResourceAsStream(String name) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(name);
        }
        if (this.classloader != null) {
            return this.classloader.getResourceAsStream(name);
        }
        return null;
    }

    public String[] getAvailableNames() {
        TreeSet<String> names = new TreeSet<String>();
        PaletteFactory factory = this;
        do {
            factory.getAvailableNames(names);
        } while ((factory = factory.fallback) != null);
        return names.toArray(new String[names.size()]);
    }

    private void getAvailableNames(Collection<String> names) {
        File dir;
        String filename = new File(this.directory, LIST_FILE).getPath();
        LineNumberReader in = this.getReader(LIST_FILE, "getAvailableNames");
        try {
            if (in != null) {
                PaletteFactory.readNames(in, names);
            }
            if (this.classloader != null) {
                Enumeration<URL> it = this.classloader.getResources(filename);
                while (it.hasMoreElements()) {
                    URL url = it.nextElement();
                    in = this.getReader(url.openStream());
                    PaletteFactory.readNames(in, names);
                }
            }
        }
        catch (IOException e) {
            Logging.unexpectedException(PaletteFactory.class, (String)"getAvailableNames", (Throwable)e);
        }
        File file = dir = this.directory != null ? this.directory : new File(".");
        if (this.classloader != null ? (dir = PaletteFactory.toFile(this.classloader.getResource(dir.getPath()))) == null : this.loader != null && (dir = PaletteFactory.toFile(this.loader.getResource(dir.getPath()))) == null) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        String[] list = dir.list((FilenameFilter)new DefaultFileFilter('*' + this.extension));
        int extLg = this.extension.length();
        for (int i = 0; i < list.length; ++i) {
            filename = list[i];
            int lg = filename.length();
            if (lg <= extLg || !filename.regionMatches(true, lg - extLg, this.extension, 0, extLg)) continue;
            names.add(filename.substring(0, lg - extLg));
        }
    }

    private static void readNames(BufferedReader in, Collection<String> names) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            names.add(line);
        }
        in.close();
    }

    private static File toFile(URL url) {
        if (url != null && url.getProtocol().equalsIgnoreCase("file")) {
            return new File(url.getPath());
        }
        return null;
    }

    private LineNumberReader getPaletteReader(String name) {
        if (this.extension != null && !name.endsWith(this.extension)) {
            name = name + this.extension;
        }
        return this.getReader(name, "getPalette");
    }

    private LineNumberReader getReader(String name, String caller) {
        InputStream stream;
        block5: {
            File file = new File(this.directory, name);
            String path = file.getPath().replace(File.separatorChar, '/');
            try {
                stream = this.getResourceAsStream(path);
                if (stream != null) break block5;
                if (file.canRead()) {
                    try {
                        stream = new FileInputStream(file);
                        break block5;
                    }
                    catch (FileNotFoundException e) {
                        Logging.unexpectedException(PaletteFactory.class, (String)caller, (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            catch (SecurityException e) {
                Logging.recoverableException(PaletteFactory.class, (String)caller, (Throwable)e);
                return null;
            }
        }
        return this.getReader(stream);
    }

    private LineNumberReader getReader(InputStream stream) {
        return new LineNumberReader(this.charset != null ? new InputStreamReader(stream, this.charset) : new InputStreamReader(stream));
    }

    private Color[] getColors(LineNumberReader input, String name) throws IOException {
        String line;
        int[] values = null;
        LineFormat reader = this.locale != null ? new LineFormat(this.locale) : new LineFormat();
        ArrayList<Color> colors = new ArrayList<Color>();
        while ((line = input.readLine()) != null) {
            try {
                Color color;
                int R;
                int G;
                int B;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || reader.setLine(line) == 0) continue;
                values = reader.getValues(values);
                int A = 255;
                switch (values.length) {
                    case 4: {
                        A = this.byteValue(values[3]);
                    }
                    case 3: {
                        B = this.byteValue(values[2]);
                        G = this.byteValue(values[1]);
                        R = this.byteValue(values[0]);
                        break;
                    }
                    default: {
                        throw this.syntaxError(input, name, null);
                    }
                }
                try {
                    color = new Color(R, G, B, A);
                }
                catch (IllegalArgumentException exception) {
                    throw this.syntaxError(input, name, exception);
                }
                colors.add(color);
            }
            catch (ParseException exception) {
                throw this.syntaxError(input, name, exception);
            }
        }
        return colors.toArray(new Color[colors.size()]);
    }

    private IIOException syntaxError(LineNumberReader input, String name, Exception cause) {
        String message = this.getErrorResources().getString(4, (Object)name, (Object)input.getLineNumber());
        if (cause != null) {
            message = message + cause.getLocalizedMessage();
        }
        return new IIOException(message, cause);
    }

    public Color[] getColors(String name) throws IOException {
        LineNumberReader reader = this.getPaletteReader(name);
        if (reader == null) {
            return this.fallback != null ? this.fallback.getColors(name) : null;
        }
        Color[] colors = this.getColors(reader, name);
        reader.close();
        return colors;
    }

    private int byteValue(int value) throws ParseException {
        if (value >= 0 && value < 256) {
            return value;
        }
        throw new ParseException(this.getErrorResources().getString(122, (Object)value), 0);
    }

    public Palette getPalette(String name, int size) {
        return this.getPalette(name, 0, size, size, 1, 0);
    }

    public Palette getPalettePadValueFirst(String name, int size) {
        return this.getPalette(name, 1, size, size, 1, 0);
    }

    public Palette getPalettePadValueLast(String name, int size) {
        return this.getPalette(name, 0, size - 1, size, 1, 0);
    }

    public Palette getPalette(String name, int lower, int upper, int size, int numBands, int visibleBand) {
        Palette palette = new IndexedPalette(this, name, lower, upper, size, numBands, visibleBand);
        palette = (Palette)this.palettes.unique((Object)palette);
        return palette;
    }

    public Palette getContinuousPalette(String name, float minimum, float maximum, int dataType, int numBands, int visibleBand) {
        Palette palette = new ContinuousPalette(this, name, minimum, maximum, dataType, numBands, visibleBand);
        palette = (Palette)this.palettes.unique((Object)palette);
        return palette;
    }
}

