/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.ImageGeometry;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.io.mosaic.ComparedTileManager;
import org.geotools.image.io.mosaic.FilenameFormatter;
import org.geotools.image.io.mosaic.GridTileManager;
import org.geotools.image.io.mosaic.MosaicImageReader;
import org.geotools.image.io.mosaic.MosaicImageWriteParam;
import org.geotools.image.io.mosaic.MosaicImageWriter;
import org.geotools.image.io.mosaic.OverviewLevel;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileLayout;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.image.io.mosaic.TileManagerFactory;
import org.geotools.image.io.mosaic.TileWritingPolicy;
import org.geotools.math.Fraction;
import org.geotools.math.XMath;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;

public class MosaicBuilder {
    private static final int DEFAULT_TILE_SIZE = 512;
    private static final int MIN_TILE_SIZE = 64;
    protected final TileManagerFactory factory;
    private TileLayout layout;
    private File directory;
    private ImageReaderSpi tileReaderSpi;
    private GeneralEnvelope mosaicEnvelope;
    private Rectangle untiledBounds;
    private Dimension tileSize;
    private int[] subsamplings;
    private final FilenameFormatter formatter;
    private Level logLevel = Level.FINE;

    public MosaicBuilder() {
        this(null);
    }

    public MosaicBuilder(TileManagerFactory factory) {
        this.factory = factory != null ? factory : TileManagerFactory.DEFAULT;
        this.layout = TileLayout.CONSTANT_TILE_SIZE;
        this.formatter = new FilenameFormatter();
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level level) {
        if (level == null) {
            level = Level.FINE;
        }
        this.logLevel = level;
    }

    public TileLayout getTileLayout() {
        return this.layout;
    }

    public void setTileLayout(TileLayout layout) {
        if (layout != null) {
            switch (layout) {
                case CONSTANT_TILE_SIZE: 
                case CONSTANT_GEOGRAPHIC_AREA: {
                    this.layout = layout;
                    return;
                }
            }
        }
        throw new IllegalArgumentException(Errors.format((int)42, (Object)"layout", (Object)((Object)layout)));
    }

    public File getTileDirectory() {
        return this.directory;
    }

    public void setTileDirectory(File directory) {
        this.directory = directory;
    }

    public ImageReaderSpi getTileReaderSpi() {
        return this.tileReaderSpi;
    }

    public void setTileReaderSpi(ImageReaderSpi provider) {
        this.tileReaderSpi = provider;
    }

    public void setTileReaderSpi(String format) throws IllegalArgumentException {
        ImageReaderSpi spi = null;
        if (format != null) {
            format = format.trim();
            IIORegistry registry = IIORegistry.getDefaultInstance();
            Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, true);
            do {
                if (it.hasNext()) continue;
                throw new IllegalArgumentException(Errors.format((int)203, (Object)format));
            } while (!XArray.contains((Object[])(spi = it.next()).getFormatNames(), (Object)format));
        }
        this.setTileReaderSpi(spi);
    }

    public Envelope getMosaicEnvelope() {
        return this.mosaicEnvelope != null ? this.mosaicEnvelope.clone() : null;
    }

    public void setMosaicEnvelope(Envelope envelope) {
        this.mosaicEnvelope = envelope != null ? new GeneralEnvelope(envelope) : null;
    }

    public Rectangle getUntiledImageBounds() {
        return this.untiledBounds != null ? (Rectangle)this.untiledBounds.clone() : null;
    }

    public void setUntiledImageBounds(Rectangle bounds) {
        this.untiledBounds = bounds != null ? new Rectangle(bounds) : null;
    }

    public Dimension getTileSize() {
        if (this.tileSize == null) {
            Rectangle untiledBounds = this.getUntiledImageBounds();
            if (untiledBounds == null) {
                return null;
            }
            int width = untiledBounds.width;
            int height = untiledBounds.height;
            width = MosaicBuilder.suggestedTileSize(width);
            height = height == untiledBounds.width ? width : MosaicBuilder.suggestedTileSize(height);
            this.tileSize = new Dimension(width, height);
        }
        return (Dimension)this.tileSize.clone();
    }

    public void setTileSize(Dimension size) {
        if (size == null) {
            this.tileSize = null;
        } else {
            if (size.width < 2 || size.height < 2) {
                throw new IllegalArgumentException(Errors.format((int)167, (Object)"size"));
            }
            this.tileSize = new Dimension(size);
        }
    }

    private static int suggestedTileSize(int imageSize) {
        return MosaicBuilder.suggestedTileSize(imageSize, 512, 384, 640);
    }

    public static int suggestedTileSize(int imageSize, int tileSize, int minSize, int maxSize) throws IllegalArgumentException {
        if (minSize <= 1 || minSize > maxSize) {
            throw new IllegalArgumentException(Errors.format((int)13, (Object)minSize, (Object)maxSize));
        }
        if (tileSize < minSize || tileSize > maxSize) {
            throw new IllegalArgumentException(Errors.format((int)145, (Object)tileSize, (Object)minSize, (Object)maxSize));
        }
        if (imageSize <= minSize) {
            return imageSize;
        }
        int numDivisors = 0;
        int best = tileSize;
        for (int i = minSize; i <= maxSize; ++i) {
            int n;
            if (imageSize % i != 0 || (n = XMath.divisors((int)Fraction.round((int)imageSize, (int)i)).length) < numDivisors || n == numDivisors && Math.abs(i - tileSize) >= Math.abs(best - tileSize)) continue;
            best = i;
            numDivisors = n;
        }
        return best;
    }

    public static int[][] suggestedNumTiles(Rectangle imageBounds, Dimension tileSize, int preferredCount, boolean multiples) {
        int width = tileSize.width;
        int height = tileSize.height;
        int[][] divisors = new int[2][];
        int xmax = imageBounds.width / width;
        int ymax = imageBounds.height / height;
        int maxScale = Math.min(tileSize.width, tileSize.height) / 64;
        int scale = 1;
        boolean oldTileDivideImage = false;
        do {
            int[] sy;
            boolean tileDivideImage;
            int[] oldX = divisors[0];
            int[] oldY = divisors[1];
            long dx = (long)scale * (long)imageBounds.width;
            long dy = (long)scale * (long)imageBounds.height;
            int nx = (int)Fraction.round((long)dx, (long)width);
            int ny = (int)Fraction.round((long)dy, (long)height);
            boolean bl = tileDivideImage = (long)(nx * width) == dx && (long)(ny * height) == dy;
            if (oldTileDivideImage && !tileDivideImage) continue;
            int[] sx = XMath.divisors((int)nx);
            if (nx == ny) {
                sy = sx = XArray.resize((int[])sx, (int)MosaicBuilder.decimate(sx, Math.min(xmax, ymax), multiples));
                divisors[0] = divisors[1] = sx;
            } else {
                sy = XMath.divisors((int)ny);
                sx = XArray.resize((int[])sx, (int)MosaicBuilder.decimate(sx, xmax, multiples));
                divisors[0] = sx;
                sy = XArray.resize((int[])sy, (int)MosaicBuilder.decimate(sy, ymax, multiples));
                divisors[1] = sy;
                MosaicBuilder.reduceLargest(divisors);
            }
            int length = divisors[0].length;
            if (tileDivideImage && length >= preferredCount) break;
            if (oldX == null) continue;
            if (tileDivideImage && !oldTileDivideImage) {
                oldTileDivideImage = true;
                continue;
            }
            if (length > oldX.length) continue;
            divisors[0] = oldX;
            divisors[1] = oldY;
        } while (++scale <= maxScale);
        return divisors;
    }

    private static int decimate(int[] divisors, int maximum, boolean multiples) {
        int n;
        assert (XArray.isStrictlySorted((int[])divisors));
        if (!multiples) {
            n = Arrays.binarySearch(divisors, maximum);
            if (n < 0) {
                n = ~n - 1;
            }
        } else {
            int x;
            n = 0;
            for (int i = 1; i < divisors.length && (x = divisors[i]) <= maximum; ++i) {
                if (x % divisors[n] != 0) continue;
                divisors[++n] = x;
            }
        }
        return ++n;
    }

    private static void reduceLargest(int[][] divisors) {
        int target;
        int[] large = divisors[0];
        int[] small = divisors[1];
        assert (XArray.isStrictlySorted((int[])large) && XArray.isStrictlySorted((int[])small));
        if (large.length == small.length) {
            return;
        }
        if (large.length >= small.length) {
            target = 0;
        } else {
            target = 1;
            int[] tmp = large;
            large = small;
            small = tmp;
        }
        int[] reduced = new int[small.length];
        for (int i = 0; i < small.length; ++i) {
            int value = small[i];
            int k = Arrays.binarySearch(large, value);
            if (k < 0) {
                if ((k ^= 0xFFFFFFFF) != 0 && (k == large.length || large[k] - value >= value - large[k - 1])) {
                    --k;
                }
                value = large[k];
            }
            reduced[i] = value;
        }
        divisors[target] = reduced;
    }

    public Dimension[] getSubsamplings() {
        if (this.subsamplings == null) {
            Rectangle untiledBounds = this.getUntiledImageBounds();
            if (untiledBounds == null) {
                return null;
            }
            Dimension tileSize = this.getTileSize();
            if (tileSize == null) {
                return null;
            }
            boolean constantArea = TileLayout.CONSTANT_GEOGRAPHIC_AREA.equals((Object)this.layout);
            int nx = tileSize.width;
            int ny = tileSize.height;
            if (!constantArea) {
                nx = Fraction.round((int)untiledBounds.width, (int)nx);
                ny = Fraction.round((int)untiledBounds.height, (int)ny);
            }
            int[] xSubsamplings = XMath.divisors((int)nx);
            if (nx != ny) {
                int[] ySubsamplings = XMath.divisors((int)ny);
                int[] union = new int[xSubsamplings.length + ySubsamplings.length];
                int nu = 0;
                int ix = 0;
                int iy = 0;
                while (true) {
                    int s;
                    int no;
                    if (ix == xSubsamplings.length) {
                        no = ySubsamplings.length - iy;
                        System.arraycopy(ySubsamplings, iy, union, nu, no);
                        nu += no;
                        break;
                    }
                    if (iy == ySubsamplings.length) {
                        no = xSubsamplings.length - ix;
                        System.arraycopy(xSubsamplings, ix, union, nu, no);
                        nu += no;
                        break;
                    }
                    int sx = xSubsamplings[ix];
                    int sy = ySubsamplings[iy];
                    if (sx <= sy) {
                        s = sx;
                        ++ix;
                        if (sx == sy) {
                            ++iy;
                        }
                    } else {
                        s = sy;
                        ++iy;
                    }
                    union[nu++] = s;
                }
                xSubsamplings = XArray.resize((int[])union, (int)nu);
            }
            if (constantArea) {
                nx = tileSize.width / 64;
                ny = tileSize.height / 64;
            } else {
                nx = (untiledBounds.width - 1) / tileSize.width + 1;
                ny = (untiledBounds.height - 1) / tileSize.height + 1;
            }
            nx = Arrays.binarySearch(xSubsamplings, nx);
            if (nx < 0) {
                nx ^= 0xFFFFFFFF;
            }
            ++nx;
            if ((ny = Arrays.binarySearch(xSubsamplings, ny)) < 0) {
                ny ^= 0xFFFFFFFF;
            }
            int length = Math.min(Math.max(nx, ++ny), xSubsamplings.length);
            this.subsamplings = new int[length * 2];
            int source = 0;
            for (int i = 0; i < length; ++i) {
                this.subsamplings[source++] = xSubsamplings[i];
                this.subsamplings[source++] = xSubsamplings[i];
            }
        }
        Dimension[] dimensions = new Dimension[this.subsamplings.length / 2];
        int source = 0;
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = new Dimension(this.subsamplings[source++], this.subsamplings[source++]);
        }
        return dimensions;
    }

    public void setSubsamplings(Dimension[] subsamplings) {
        int[] newSubsamplings;
        if (subsamplings == null) {
            newSubsamplings = null;
        } else {
            int target = 0;
            newSubsamplings = new int[subsamplings.length * 2];
            for (int i = 0; i < subsamplings.length; ++i) {
                Dimension subsampling = subsamplings[i];
                int xSubsampling = subsampling.width;
                int ySubsampling = subsampling.height;
                if (xSubsampling < 1 || ySubsampling < 1) {
                    throw new IllegalArgumentException(Errors.format((int)167, (Object)("subsamplings[" + i + ']')));
                }
                newSubsamplings[target++] = xSubsampling;
                newSubsamplings[target++] = ySubsampling;
            }
        }
        this.subsamplings = newSubsamplings;
    }

    public void setSubsamplings(int[] subsamplings) {
        Dimension[] newSubsamplings;
        if (subsamplings == null) {
            newSubsamplings = null;
        } else {
            newSubsamplings = new Dimension[subsamplings.length];
            for (int i = 0; i < subsamplings.length; ++i) {
                int subsampling = subsamplings[i];
                newSubsamplings[i] = new Dimension(subsampling, subsampling);
            }
        }
        this.setSubsamplings(newSubsamplings);
    }

    public TileManager createTileManager() throws IOException {
        return this.createFromInput(null);
    }

    private TileManager createFromInput(TileManager input) throws IOException {
        TileManager output;
        this.tileReaderSpi = this.getTileReaderSpi();
        if (this.tileReaderSpi == null) {
            throw new IllegalStateException(Errors.format((int)98));
        }
        this.untiledBounds = this.getUntiledImageBounds();
        if (this.untiledBounds == null) {
            throw new IllegalStateException(Errors.format((int)141));
        }
        this.tileSize = this.getTileSize();
        if (this.tileSize == null) {
            this.tileSize = ImageUtilities.toTileSize((Dimension)this.untiledBounds.getSize());
        }
        this.formatter.initialize(this.tileReaderSpi);
        boolean constantArea = false;
        switch (this.layout) {
            case CONSTANT_GEOGRAPHIC_AREA: {
                constantArea = true;
            }
            case CONSTANT_TILE_SIZE: {
                output = this.createFromInput(constantArea, this.canUsePattern(), input);
                break;
            }
            default: {
                throw new IllegalStateException(this.layout.toString());
            }
        }
        if (this.mosaicEnvelope != null && !this.mosaicEnvelope.isNull()) {
            GridToEnvelopeMapper mapper = this.createGridToEnvelopeMapper(output);
            mapper.setGridRange((GridEnvelope)new GridEnvelope2D(this.untiledBounds));
            mapper.setEnvelope((Envelope)this.mosaicEnvelope);
            output.setGridToCRS((AffineTransform)mapper.createTransform());
        }
        return output;
    }

    private TileManager createFromInput(boolean constantArea, boolean usePattern, TileManager input) throws IOException {
        TileManager manager;
        OverviewLevel[] levels;
        ArrayList<Tile> tiles;
        Dimension tileSize = this.tileSize;
        Rectangle untiledBounds = this.untiledBounds;
        Rectangle imageBounds = new Rectangle(untiledBounds);
        Rectangle tileBounds = new Rectangle(tileSize);
        Dimension[] subsamplings = this.getSubsamplings();
        if (subsamplings == null) {
            int n = constantArea ? Math.max(tileBounds.width, tileBounds.height) / 64 : Math.max(imageBounds.width / tileBounds.width, imageBounds.height / tileBounds.height);
            subsamplings = new Dimension[n];
            for (int i = 1; i <= n; ++i) {
                subsamplings[i - 1] = new Dimension(i, i);
            }
        }
        if (usePattern) {
            tiles = null;
            levels = new OverviewLevel[subsamplings.length];
        } else {
            tiles = new ArrayList<Tile>();
            levels = null;
        }
        Rectangle absoluteBounds = new Rectangle();
        this.formatter.computeLevelFieldSize(subsamplings.length);
        for (int level = 0; level < subsamplings.length; ++level) {
            Dimension subsampling = subsamplings[level];
            int xSubsampling = subsampling.width;
            int ySubsampling = subsampling.height;
            imageBounds.setBounds(untiledBounds.x / xSubsampling, untiledBounds.y / ySubsampling, untiledBounds.width / xSubsampling, untiledBounds.height / ySubsampling);
            tileBounds.setBounds(imageBounds);
            tileBounds.setSize(tileSize);
            if (constantArea) {
                tileBounds.width /= xSubsampling;
                tileBounds.height /= ySubsampling;
            } else {
                if (tileBounds.width > imageBounds.width) {
                    tileBounds.width = imageBounds.width;
                }
                if (tileBounds.height > imageBounds.height) {
                    tileBounds.height = imageBounds.height;
                }
            }
            this.formatter.computeFieldSizes(imageBounds, tileBounds);
            if (usePattern) {
                String pattern = this.formatter.toString();
                pattern = new File(this.directory, pattern).getPath();
                pattern = "File:" + pattern;
                Tile tile = new Tile(this.tileReaderSpi, (Object)pattern, 0, tileBounds, subsampling);
                OverviewLevel ol = new OverviewLevel(tile, imageBounds);
                ol.createLinkedList(level, level != 0 ? levels[level - 1] : null);
                if (input != null) {
                    int nx = ol.getNumXTiles();
                    int ny = ol.getNumYTiles();
                    absoluteBounds.width = xSubsampling * tileBounds.width;
                    absoluteBounds.height = ySubsampling * tileBounds.height;
                    absoluteBounds.y = ySubsampling * tileBounds.y;
                    for (int y = 0; y < ny; ++y) {
                        absoluteBounds.x = xSubsampling * tileBounds.x;
                        for (int x = 0; x < nx; ++x) {
                            if (!input.intersects(absoluteBounds, subsampling)) {
                                ol.removeTile(x, y);
                            }
                            absoluteBounds.x += absoluteBounds.width;
                        }
                        absoluteBounds.y += absoluteBounds.height;
                    }
                }
                levels[level] = ol;
                continue;
            }
            int xmin = imageBounds.x;
            int ymin = imageBounds.y;
            int xmax = imageBounds.width + xmin;
            int ymax = imageBounds.height + ymin;
            int dx = tileBounds.width;
            int dy = tileBounds.height;
            absoluteBounds.width = xSubsampling * dx;
            absoluteBounds.height = ySubsampling * dy;
            int y = 0;
            tileBounds.y = ymin;
            while (tileBounds.y < ymax) {
                int x = 0;
                absoluteBounds.y = ySubsampling * tileBounds.y;
                tileBounds.x = xmin;
                while (tileBounds.x < xmax) {
                    block24: {
                        block23: {
                            if (input == null) break block23;
                            absoluteBounds.x = xSubsampling * tileBounds.x;
                            if (!input.intersects(absoluteBounds, subsampling)) break block24;
                        }
                        Rectangle clippedBounds = tileBounds.intersection(imageBounds);
                        File file = new File(this.directory, this.generateFilename(level, x, y));
                        Tile tile = new Tile(this.tileReaderSpi, (Object)file, 0, clippedBounds, subsampling);
                        tiles.add(tile);
                    }
                    tileBounds.x += dx;
                    ++x;
                }
                tileBounds.y += dy;
                ++y;
            }
        }
        if (usePattern) {
            manager = new GridTileManager(levels[levels.length - 1]);
            assert (!new ComparedTileManager(manager, this.createFromInput(constantArea, false, input)).getTiles().isEmpty());
        } else {
            TileManager[] managers = this.factory.create(tiles);
            manager = managers[0];
        }
        return manager;
    }

    public TileManager createTileManager(Object input) throws IOException {
        return this.createTileManager(input, 0, TileWritingPolicy.NO_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileManager createTileManager(Object input, int inputIndex, TileWritingPolicy policy) throws IOException {
        this.formatter.ensurePrefixSet(input);
        Writer writer = new Writer(inputIndex, policy);
        writer.setLogLevel(this.getLogLevel());
        MosaicImageWriteParam param = writer.getDefaultWriteParam();
        param.setTileWritingPolicy(policy);
        try {
            if (!writer.writeFromInput(input, inputIndex, param)) {
                TileManager tileManager = null;
                return tileManager;
            }
        }
        finally {
            writer.dispose();
        }
        TileManager tiles = writer.outputTiles;
        if (tiles.geometry == null && writer.inputTiles != null) {
            for (TileManager candidate : writer.inputTiles) {
                ImageGeometry geometry = candidate.getGridGeometry();
                if (geometry == null) continue;
                tiles.setGridToCRS((AffineTransform)geometry.getGridToCRS());
                break;
            }
        }
        return tiles;
    }

    private boolean canUsePattern() {
        Object[] parameters = new Class[3];
        Arrays.fill(parameters, Integer.TYPE);
        Class<?> classe = this.getClass();
        while (true) {
            try {
                Method method = classe.getDeclaredMethod("generateFilename", (Class<?>[])parameters);
                return method.getDeclaringClass().equals(MosaicBuilder.class);
            }
            catch (NoSuchMethodException e) {
                if ((classe = classe.getSuperclass()) != null) continue;
                throw new AssertionError();
            }
            break;
        }
    }

    protected String generateFilename(int level, int column, int row) {
        return this.formatter.generateFilename(level, column, row);
    }

    protected GridToEnvelopeMapper createGridToEnvelopeMapper(TileManager tiles) {
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
        mapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        return mapper;
    }

    protected void onTileWrite(Tile tile, ImageWriteParam parameters) throws IOException {
    }

    private final class Writer
    extends MosaicImageWriter {
        private final TileWritingPolicy policy;
        private final int inputIndex;
        TileManager[] inputTiles;
        TileManager outputTiles;

        Writer(int inputIndex, TileWritingPolicy policy) {
            this.inputIndex = inputIndex;
            this.policy = policy;
        }

        protected boolean filter(ImageReader reader) throws IOException {
            ImageReaderSpi spi;
            Rectangle bounds = new Rectangle();
            bounds.width = reader.getWidth(this.inputIndex);
            bounds.height = reader.getHeight(this.inputIndex);
            TileManager input = null;
            if (reader instanceof MosaicImageReader) {
                MosaicImageReader mosaic = (MosaicImageReader)reader;
                this.inputTiles = mosaic.getInput();
                if (this.inputTiles.length > this.inputIndex && this.policy != null && !this.policy.includeEmpty) {
                    input = this.inputTiles[this.inputIndex];
                }
                reader = mosaic.getTileReader();
            }
            if (reader != null && (spi = reader.getOriginatingProvider()) != null && MosaicBuilder.this.getTileReaderSpi() == null) {
                MosaicBuilder.this.setTileReaderSpi(spi);
            }
            MosaicBuilder.this.setUntiledImageBounds(bounds);
            this.outputTiles = MosaicBuilder.this.createFromInput(input);
            try {
                this.setOutput(this.outputTiles);
            }
            catch (IllegalArgumentException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw exception;
            }
            return true;
        }

        protected void onTileWrite(Tile tile, ImageWriteParam parameters) throws IOException {
            MosaicBuilder.this.onTileWrite(tile, parameters);
        }
    }
}

