/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.ImageGeometry;
import org.geotools.image.io.mosaic.LargeTile;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.FrequencySortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TileManager
implements Serializable {
    private static final long serialVersionUID = -7645850962821189968L;
    ImageGeometry geometry;
    transient Set<ImageReaderSpi> providers;

    protected TileManager() {
    }

    public synchronized void setGridToCRS(AffineTransform gridToCRS) throws IllegalStateException, IOException {
        if (this.geometry != null) {
            throw new IllegalStateException();
        }
        HashMap<Dimension, Object> shared = new HashMap<Dimension, Object>();
        Object at = new XAffineTransform(gridToCRS);
        shared.put(new Dimension(1, 1), at);
        this.geometry = new ImageGeometry(this.getRegion(), (AffineTransform)at);
        for (Tile tile : this.getInternalTiles()) {
            Dimension subsampling = tile.getSubsampling();
            at = (AffineTransform)shared.get(subsampling);
            if (at == null) {
                at = new AffineTransform(gridToCRS);
                ((AffineTransform)at).scale(subsampling.width, subsampling.height);
                at = new XAffineTransform((AffineTransform)at);
                shared.put(subsampling, at);
            }
            tile.setGridToCRS((AffineTransform)at);
        }
    }

    public synchronized ImageGeometry getGridGeometry() throws IOException {
        if (this.geometry == null) {
            for (Tile tile : this.getInternalTiles()) {
                AffineTransform gridToCRS;
                Dimension subsampling = tile.getSubsampling();
                if (subsampling.width != 1 || subsampling.height != 1) continue;
                Point origin = tile.getLocation();
                if (origin.x != 0 || origin.y != 0 || (gridToCRS = tile.getGridToCRS()) == null) continue;
                this.geometry = new ImageGeometry(this.getRegion(), gridToCRS);
                break;
            }
        }
        return this.geometry;
    }

    Rectangle getRegion() throws IOException {
        return this.getGridGeometry().getGridRange();
    }

    Dimension getTileSize() throws IOException {
        return this.getRegion().getSize();
    }

    boolean isImageTiled() throws IOException {
        return true;
    }

    public synchronized Set<ImageReaderSpi> getImageReaderSpis() throws IOException {
        if (this.providers == null) {
            FrequencySortedSet providers = new FrequencySortedSet(4, true);
            Collection<Tile> tiles = this.getInternalTiles();
            int[] frequencies = null;
            if (tiles instanceof FrequencySortedSet) {
                frequencies = ((FrequencySortedSet)tiles).frequencies();
            }
            int i = 0;
            for (Tile tile : tiles) {
                int n = frequencies != null ? frequencies[i++] : 1;
                providers.add((Object)tile.getImageReaderSpi(), n);
            }
            this.providers = Collections.unmodifiableSet(providers);
        }
        return this.providers;
    }

    public Tile createGlobalTile(ImageReaderSpi provider, Object input, int imageIndex) throws NoSuchElementException, IOException {
        LargeTile tile;
        ImageGeometry geometry;
        if (provider == null) {
            List<String> f2;
            List<String> f1;
            provider = this.getImageReaderSpis().iterator().next();
            ImageReaderSpi inferred = Tile.getImageReaderSpi(input);
            if (inferred != null && inferred != provider && !(f1 = Arrays.asList(provider.getFormatNames())).containsAll(f2 = Arrays.asList(inferred.getFormatNames()))) {
                provider = inferred;
            }
        }
        if ((geometry = this.getGridGeometry()) == null) {
            tile = new LargeTile(provider, input, imageIndex, this.getRegion());
        } else {
            tile = new LargeTile(provider, input, imageIndex, (Rectangle)geometry.getGridRange());
            tile.setGridToCRS((AffineTransform)geometry.getGridToCRS());
        }
        return tile;
    }

    Collection<Tile> getInternalTiles() throws IOException {
        return this.getTiles();
    }

    public abstract Collection<Tile> getTiles() throws IOException;

    public abstract Collection<Tile> getTiles(Rectangle var1, Dimension var2, boolean var3) throws IOException;

    public boolean intersects(Rectangle region, Dimension subsampling) throws IOException {
        return !this.getTiles(region, subsampling, false).isEmpty();
    }

    public void printErrors(PrintWriter out) {
        Collection<Tile> tiles;
        if (out == null) {
            out = new PrintWriter(System.out, true);
        }
        try {
            tiles = this.getTiles();
        }
        catch (IOException e) {
            e.printStackTrace(out);
            return;
        }
        for (Tile tile : tiles) {
            int imageIndex = tile.getImageIndex();
            ImageReader reader = null;
            String message = null;
            try {
                Rectangle region = tile.getRegion();
                reader = tile.getImageReader();
                int width = reader.getWidth(imageIndex);
                int height = reader.getHeight(imageIndex);
                if (width != region.width || height != region.height) {
                    message = Errors.format((int)128);
                }
                Tile.dispose(reader);
                reader = null;
            }
            catch (IOException exception) {
                message = exception.toString();
            }
            catch (RuntimeException exception) {
                message = exception.toString();
            }
            if (message != null) {
                out.println(tile);
                out.print("    ");
                out.println(message);
            }
            if (reader == null) continue;
            reader.dispose();
        }
    }

    public String toString() {
        Collection<Tile> tiles;
        try {
            tiles = this.getTiles();
        }
        catch (IOException e) {
            return e.toString();
        }
        return Tile.toString(tiles, 10000);
    }
}

