/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.image.io.GeographicImageWriter;
import org.geotools.image.io.OutputStreamAdapter;
import org.geotools.resources.Classes;
import org.geotools.util.logging.Logging;

public abstract class StreamImageWriter
extends GeographicImageWriter {
    protected Closeable closeOnReset;
    private OutputStream stream;

    protected StreamImageWriter(ImageWriterSpi provider) {
        super(provider);
    }

    public void setOutput(Object output) {
        this.closeSilently();
        super.setOutput(output);
    }

    protected OutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.stream == null) {
            Object output = this.getOutput();
            if (output == null) {
                throw new IllegalStateException();
            }
            if (output instanceof OutputStream) {
                this.stream = (OutputStream)output;
                this.closeOnReset = null;
            } else if (output instanceof ImageOutputStream) {
                this.stream = new OutputStreamAdapter((ImageOutputStream)output);
                this.closeOnReset = null;
            } else if (output instanceof String) {
                this.stream = new FileOutputStream((String)output);
                this.closeOnReset = this.stream;
            } else if (output instanceof File) {
                this.stream = new FileOutputStream((File)output);
                this.closeOnReset = this.stream;
            } else if (output instanceof URL) {
                this.stream = ((URL)output).openConnection().getOutputStream();
                this.closeOnReset = this.stream;
            } else if (output instanceof URLConnection) {
                this.stream = ((URLConnection)output).getOutputStream();
                this.closeOnReset = this.stream;
            } else {
                throw new IllegalStateException(this.getErrorResources().getString(61, (Object)Classes.getClass((Object)output), OutputStream.class));
            }
        }
        return this.stream;
    }

    protected void close() throws IOException {
        if (this.closeOnReset != null) {
            this.closeOnReset.close();
        }
        this.closeOnReset = null;
        this.stream = null;
        super.close();
    }

    private void closeSilently() {
        try {
            this.close();
        }
        catch (IOException exception) {
            Logging.unexpectedException((Logger)LOGGER, this.getClass(), (String)"close", (Throwable)exception);
        }
    }

    public void reset() {
        this.closeSilently();
        super.reset();
    }

    public void dispose() {
        this.closeSilently();
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static abstract class Spi
    extends ImageWriterSpi {
        private static final Class[] OUTPUT_TYPES = new Class[]{File.class, URL.class, URLConnection.class, OutputStream.class, ImageOutputStream.class, String.class};

        public Spi() {
            this.outputTypes = OUTPUT_TYPES;
        }

        public boolean canEncodeImage(ImageTypeSpecifier type) {
            return true;
        }
    }
}

