/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.ImageGeometry;
import org.geotools.image.io.metadata.ImageReferencing;
import org.geotools.image.io.text.TextMetadataParser;
import org.geotools.referencing.factory.ReferencingFactoryContainer;

public class DefaultTextMetadataParser
extends TextMetadataParser {
    private String unit;
    private String crs_name;
    private String crs_type;
    private String cs_name;
    private String cs_type;
    private String xdir;
    private String ydir;
    private String zdir;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;
    private double xres;
    private double yres;
    private double zres;

    public DefaultTextMetadataParser() {
    }

    public DefaultTextMetadataParser(ReferencingFactoryContainer factories) {
        super(factories);
    }

    protected void put(TextMetadataParser.Key key, Object value) {
        ImageGeometry geometry = this.metadata.getGeometry();
        ImageReferencing referencing = this.metadata.getReferencing();
        if (key.equals(UNIT) && value instanceof String) {
            this.unit = (String)value;
            return;
        }
        if (key.equals(X_MINIMUM)) {
            this.xmin = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(Y_MINIMUM)) {
            this.ymin = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(Z_MINIMUM)) {
            this.zmin = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(X_MAXIMUM)) {
            this.xmax = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(Y_MAXIMUM)) {
            this.ymax = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(Z_MAXIMUM)) {
            this.zmax = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(WIDTH)) {
            geometry.setGridRange(0, 0, Integer.parseInt((String)value));
            return;
        }
        if (key.equals(HEIGHT)) {
            geometry.setGridRange(1, 0, Integer.parseInt((String)value));
            return;
        }
        if (key.equals(DEPTH)) {
            geometry.setGridRange(2, 0, Integer.parseInt((String)value));
            return;
        }
        if (key.equals(X_RESOLUTION)) {
            this.xres = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(Y_RESOLUTION)) {
            this.yres = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(Z_RESOLUTION)) {
            this.zres = value instanceof Double ? (Double)value : Double.parseDouble((String)value);
            return;
        }
        if (key.equals(X_DIRECTION) && value instanceof String) {
            this.xdir = (String)value;
            return;
        }
        if (key.equals(Y_DIRECTION) && value instanceof String) {
            this.ydir = (String)value;
            return;
        }
        if (key.equals(Z_DIRECTION) && value instanceof String) {
            this.zdir = (String)value;
            return;
        }
        if (key.equals(PROJECTION) && value instanceof String) {
            referencing.setProjectionName((String)value);
            return;
        }
        if (key.equals(DATUM) && value instanceof String) {
            referencing.setDatum((String)value, null);
            return;
        }
        if (key.equals(PRIME_MERIDIAN) && value instanceof String) {
            referencing.setPrimeMeridianName((String)value);
            return;
        }
        if (key.equals(GREENWICH_LONGITUDE)) {
            referencing.setPrimeMeridianGreenwichLongitude(value instanceof Double ? (Double)value : Double.parseDouble((String)value));
            return;
        }
        if (key.equals(ELLIPSOID) && value instanceof String) {
            referencing.setEllipsoidName((String)value);
            return;
        }
        if (key.equals(ELLIPSOID_UNIT) && value instanceof String) {
            referencing.setEllipsoidUnit((String)value);
            return;
        }
        if (key.equals(SEMI_MAJOR)) {
            if (value instanceof Double) {
                referencing.setSemiMajorAxis((Double)value);
            } else {
                referencing.setSemiMajorAxis(Double.parseDouble((String)value));
            }
            return;
        }
        if (key.equals(SEMI_MINOR)) {
            if (value instanceof Double) {
                referencing.setSemiMinorAxis((Double)value);
            } else {
                referencing.setSemiMinorAxis(Double.parseDouble((String)value));
            }
            return;
        }
        if (key.equals(INVERSE_FLATTENING)) {
            if (value instanceof Double) {
                referencing.setInverseFlattening((Double)value);
            } else {
                referencing.setInverseFlattening(Double.parseDouble((String)value));
            }
            return;
        }
        if (key.equals(COORDINATE_REFERENCE_SYSTEM_TYPE) && value instanceof String) {
            this.crs_type = (String)value;
            return;
        }
        if (key.equals(COORDINATE_REFERENCE_SYSTEM) && value instanceof String) {
            this.crs_name = (String)value;
            return;
        }
        if (key.equals(COORDINATE_SYSTEM_TYPE) && value instanceof String) {
            this.cs_type = (String)value;
            return;
        }
        if (key.equals(COORDINATE_SYSTEM) && value instanceof String) {
            this.cs_name = (String)value;
            return;
        }
        if (key.equals(CENTRAL_MERIDIAN) || key.equals(FALSE_EASTING) || key.equals(FALSE_NORTHING) || key.equals(LATITUDE_OF_ORIGIN)) {
            if (value instanceof Double) {
                referencing.addParameter(key.toString(), (Double)value);
            } else {
                referencing.addParameter(key.toString(), Double.parseDouble((String)value));
            }
            return;
        }
    }

    protected void putDone() {
        ImageGeometry geometry = this.metadata.getGeometry();
        ImageReferencing referencing = this.metadata.getReferencing();
        if (!Double.isNaN(this.xmin) && !Double.isNaN(this.xmax)) {
            geometry.setOrdinateRange(0, this.xmin, this.xmax);
            referencing.addAxis(null, this.xdir, this.unit);
        }
        if (!Double.isNaN(this.ymin) && !Double.isNaN(this.ymax)) {
            geometry.setOrdinateRange(1, this.ymin, this.ymax);
            referencing.addAxis(null, this.ydir, this.unit);
        }
        if (!Double.isNaN(this.zmin) && !Double.isNaN(this.zmax)) {
            geometry.setOrdinateRange(2, this.zmin, this.zmax);
            referencing.addAxis(null, this.zdir, this.unit);
        }
        int dimension = referencing.getDimension();
        double[] offsetVector = new double[dimension];
        if (!Double.isNaN(this.xres) && dimension > 0) {
            offsetVector[0] = this.xres;
            geometry.addOffsetVector(offsetVector);
            offsetVector[0] = 0.0;
        }
        if (!Double.isNaN(this.yres) && dimension > 1) {
            offsetVector[1] = this.yres;
            geometry.addOffsetVector(offsetVector);
            offsetVector[1] = 0.0;
        }
        if (!Double.isNaN(this.zres) && dimension > 2) {
            offsetVector[2] = this.zres;
            geometry.addOffsetVector(offsetVector);
            offsetVector[2] = 0.0;
        }
        if (this.crs_name != null || this.crs_type != null) {
            referencing.setCoordinateReferenceSystem(this.crs_name, this.crs_type);
        }
        if (this.cs_name != null || this.cs_type != null) {
            referencing.setCoordinateSystem(this.cs_name, this.cs_type);
        }
    }

    public void setGeographicMetadata(GeographicMetadata metadata) {
        super.setGeographicMetadata(metadata);
        this.xmin = Double.NaN;
        this.xmax = Double.NaN;
        this.xres = Double.NaN;
        this.xdir = null;
        this.ymin = Double.NaN;
        this.ymax = Double.NaN;
        this.yres = Double.NaN;
        this.ydir = null;
        this.zmin = Double.NaN;
        this.zmax = Double.NaN;
        this.zres = Double.NaN;
        this.zdir = null;
        this.unit = null;
        this.crs_type = null;
        this.crs_name = null;
        this.cs_type = null;
        this.cs_name = null;
    }
}

