/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import com.csvreader.CsvReader;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.csv.CSVDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    private Query query;
    private CsvReader reader;
    private SimpleFeature next;
    private SimpleFeatureBuilder builder;
    private int row;
    private GeometryFactory geometryFactory;

    public CSVFeatureReader(ContentState contentState, Query query) throws IOException {
        this.state = contentState;
        this.query = query;
        CSVDataStore csv = (CSVDataStore)contentState.getEntry().getDataStore();
        this.reader = csv.read();
        boolean header = this.reader.readHeaders();
        if (!header) {
            throw new IOException("Unable to read csv header");
        }
        this.builder = new SimpleFeatureBuilder(this.state.getFeatureType());
        this.geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        this.row = 0;
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature feature;
        if (this.next != null) {
            feature = this.next;
            this.next = null;
        } else {
            feature = this.readFeature();
        }
        return feature;
    }

    SimpleFeature readFeature() throws IOException {
        if (this.reader == null) {
            throw new IOException("FeatureReader is closed; no additional features can be read");
        }
        boolean read = this.reader.readRecord();
        if (!read) {
            this.close();
            return null;
        }
        Coordinate coordinate = new Coordinate();
        String[] stringArray = this.reader.getHeaders();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            String value = this.reader.get(column);
            if ("lat".equalsIgnoreCase(column)) {
                coordinate.y = Double.valueOf(value.trim());
            }
            if ("lon".equalsIgnoreCase(column)) {
                coordinate.x = Double.valueOf(value.trim());
            }
            this.builder.set(column, (Object)value);
            ++n2;
        }
        this.builder.set("Location", (Object)this.geometryFactory.createPoint(coordinate));
        ++this.row;
        return this.builder.buildFeature(String.valueOf(this.state.getEntry().getTypeName()) + "." + this.row);
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.readFeature();
        return this.next != null;
    }

    public void close() throws IOException {
        this.reader.close();
        this.reader = null;
        this.builder = null;
        this.geometryFactory = null;
        this.next = null;
    }
}

