/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 * 
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *    
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;

/**
 * This interface represents a shape factory that creates a shape based on a
 * string that specifies the shape build parameters.
 * 
 * @author fmoura
 */
public interface ShapeCreator
{

    /**
     * Gets this shape name
     * 
     * @return
     */
    public String getShapeName();

    /**
     * Creates the shape based on a specification string.
     * 
     * @param shapeSpecification The String that specifies the build parameters
     *            for creating a shape instance.
     * @return The shape instance created. Return null if the shapeSpecification
     *         is null or malformed.
     * 
     */
    public Shape createShape(String shapeSpecification);

}
