/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.directory.DirectoryFeatureLocking;
import org.geotools.data.directory.DirectoryFeatureSource;
import org.geotools.data.directory.DirectoryFeatureStore;
import org.geotools.data.directory.DirectoryLockingManager;
import org.geotools.data.directory.DirectoryTypeCache;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryDataStore
implements DataStore {
    DirectoryTypeCache cache;
    DirectoryLockingManager lm;

    public DirectoryDataStore(File directory, URI namespaceURI) throws IOException {
        this.cache = new DirectoryTypeCache(directory, namespaceURI);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        String typeName = query.getTypeName();
        return this.getDataStore(typeName).getFeatureReader(query, transaction);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        FeatureSource fs = this.getDataStore(typeName).getFeatureSource(typeName);
        if (fs instanceof FeatureLocking) {
            return new DirectoryFeatureLocking((FeatureLocking<SimpleFeatureType, SimpleFeature>)((FeatureLocking)fs), this);
        }
        if (fs instanceof FeatureStore) {
            return new DirectoryFeatureStore((FeatureStore<SimpleFeatureType, SimpleFeature>)((FeatureStore)fs), this);
        }
        return new DirectoryFeatureSource((FeatureSource<SimpleFeatureType, SimpleFeature>)fs, this);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        return this.getDataStore(typeName).getFeatureWriter(typeName, filter, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getDataStore(typeName).getFeatureWriter(typeName, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        return this.getDataStore(typeName).getFeatureWriterAppend(typeName, transaction);
    }

    public LockingManager getLockingManager() {
        if (this.lm == null) {
            this.lm = new DirectoryLockingManager(this.cache);
        }
        return this.lm;
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getDataStore(typeName).getSchema(typeName);
    }

    public String[] getTypeNames() throws IOException {
        Set<String> typeNames = this.cache.getTypeNames();
        return typeNames.toArray(new String[typeNames.size()]);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
        String typeName = query.getTypeName();
        return this.getDataStore(typeName).getView(query);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        this.getDataStore(typeName).updateSchema(typeName, featureType);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        File f = new File(this.cache.directory, featureType.getTypeName() + ".shp");
        String shpDataStoreClassName = "org.geotools.data.shapefile.ShapefileDataStore";
        DataStore ds = null;
        try {
            ds = (DataStore)Class.forName(shpDataStoreClassName).getConstructor(URL.class).newInstance(f.toURL());
            ds.createSchema((FeatureType)featureType);
            this.cache.refreshCacheContents();
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error creating new data store").initCause(e);
        }
    }

    public void dispose() {
        this.cache.dispose();
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.cache.directory);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.cache.directory.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(typeName));
        }
        return names;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public DataStore getDataStore(String typeName) throws IOException {
        DataStore store = this.cache.getDataStore(typeName, true);
        if (store == null) {
            throw new IOException("Feature type " + typeName + " is unknown");
        }
        return store;
    }
}

