/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.h2.jdbcx.JdbcDataSource;

public class ThreadedH2EpsgFactory
extends ThreadedEpsgFactory {
    public static final Version VERSION = new Version("7.5.0");
    private static final String ZIP_FILE = "EPSG.zip";
    static final String MARKER_FILE = "EPSG_creation_marker.txt";
    static final String LOCK_FILE = "EPSG_creation_lock.txt";
    public static final String DIRECTORY_KEY = "EPSG-H2.directory";
    public static final String DATABASE_NAME = "EPSG";
    static final String PREFIX = "jdbc:h2:";
    private static final String LOGGER = "org.geotools.referencing.factory.epsg";

    public ThreadedH2EpsgFactory() {
        this(null);
    }

    public ThreadedH2EpsgFactory(Hints hints) {
        super(hints, 91);
    }

    private static File getDirectory() {
        try {
            File directory;
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && ((directory = new File(property)).isDirectory() || directory.mkdir())) {
                return directory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ThreadedH2EpsgFactory.getTemporaryDirectory();
    }

    public static boolean isUnpacked() {
        File directory;
        try {
            String property = System.getProperty(DIRECTORY_KEY);
            if (property != null && (directory = new File(property)).exists() && directory.isDirectory()) {
                return true;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        File temp = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        directory = new File(temp, "Databases/EPSG-H2-" + VERSION + "/");
        return directory.exists() && directory.isDirectory();
    }

    private static File getTemporaryDirectory() {
        File directory = new File(System.getProperty("java.io.tmpdir", "."), "Geotools");
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Databases/EPSG-H2-" + VERSION + "/")).isDirectory() || directory.mkdirs())) {
            return directory;
        }
        return null;
    }

    private static File getDirectory(DataSource source) {
        String path;
        if (source instanceof JdbcDataSource && (path = ((JdbcDataSource)source).getURL()) != null && PREFIX.regionMatches(true, 0, path, 0, PREFIX.length())) {
            if ((path = path.substring(PREFIX.length())).indexOf(59) != -1) {
                path = path.substring(0, path.indexOf(59));
            }
            return new File(path).getParentFile();
        }
        return null;
    }

    protected DataSource createDataSource() throws SQLException {
        DataSource candidate = super.createDataSource();
        if (candidate instanceof JdbcDataSource) {
            return candidate;
        }
        JdbcDataSource source = new JdbcDataSource();
        File directory = ThreadedH2EpsgFactory.getDirectory();
        if (directory != null) {
            StringBuilder url = new StringBuilder(PREFIX);
            String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            url.append(DATABASE_NAME);
            url.append(";AUTO_RECONNECT=TRUE;CACHE_SIZE=131072;CACHE_TYPE=TQ");
            source.setURL(url.toString());
            source.setUser("sa");
            source.setPassword("");
            assert (directory.equals(ThreadedH2EpsgFactory.getDirectory((DataSource)source))) : url;
        }
        source.setUser("SA");
        return source;
    }

    private static boolean dataExists(File directory) throws SQLException {
        return new File(directory, MARKER_FILE).exists() && new File(directory, "EPSG.data.db").exists() && new File(directory, "EPSG.index.db").exists();
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        DataSource source = this.getDataSource();
        File directory = ThreadedH2EpsgFactory.getDirectory(source);
        directory.mkdirs();
        if (!ThreadedH2EpsgFactory.dataExists(directory)) {
            FileLock lock = null;
            try {
                lock = this.acquireLock(directory);
                if (!ThreadedH2EpsgFactory.dataExists(directory)) {
                    Logger logger = Logging.getLogger((String)LOGGER);
                    LogRecord record = Loggings.format((Level)Level.INFO, (int)17, (Object)VERSION);
                    record.setLoggerName(logger.getName());
                    logger.log(record);
                    ZipInputStream zin = new ZipInputStream(ThreadedH2EpsgFactory.class.getResourceAsStream(ZIP_FILE));
                    ZipEntry ze = null;
                    byte[] buf = new byte[1024];
                    int read = 0;
                    while ((ze = zin.getNextEntry()) != null) {
                        File file = new File(directory, ze.getName());
                        if (file.exists()) {
                            file.delete();
                        }
                        FileOutputStream fout = new FileOutputStream(file);
                        while ((read = zin.read(buf)) > 0) {
                            fout.write(buf, 0, read);
                        }
                        zin.closeEntry();
                        fout.close();
                    }
                    zin.close();
                    File marker = new File(directory, MARKER_FILE);
                    if (marker.exists()) {
                        marker.delete();
                    }
                    marker.createNewFile();
                    this.setReadOnly(directory);
                }
            }
            catch (IOException exception) {
                SQLException e = new SQLException(Errors.format((int)28, (Object)ZIP_FILE));
                e.initCause(exception);
                throw e;
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                        lock.channel().close();
                        new File(directory, LOCK_FILE).delete();
                    }
                    catch (IOException e) {}
                }
            }
        }
        FactoryUsingAnsiSQL factory = new FactoryUsingAnsiSQL(hints, this.getDataSource().getConnection());
        factory.setValidationQuery("CALL NOW()");
        return factory;
    }

    FileLock acquireLock(File directory) throws IOException {
        File file = new File(directory, LOCK_FILE);
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        FileLock lock = channel.lock();
        while (!lock.isValid()) {
            try {
                lock = channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return lock;
    }

    private void setReadOnly(File directory) {
        if (directory == null) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.setReadOnly(file);
                continue;
            }
            if (file.getName().endsWith(".log.db")) {
                file.delete();
                continue;
            }
            file.setReadOnly();
        }
    }
}

