/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen.info;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geotools.data.gen.info.Generalization;
import org.geotools.data.gen.info.GeneralizationInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizationInfo {
    private String featureName;
    private String baseFeatureName;
    private String geomPropertyName;
    private SortedSet<Generalization> generalizations;
    private String dataSourceName;
    private String dataSourceNameSpace;
    private GeneralizationInfos parent;

    public GeneralizationInfo(String baseFeatureName, String featureName, String geomPropertyName, GeneralizationInfos parent) {
        this.baseFeatureName = baseFeatureName;
        this.featureName = featureName;
        this.geomPropertyName = geomPropertyName;
        this.generalizations = new TreeSet<Generalization>();
        this.parent = parent;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getBaseFeatureName() {
        return this.baseFeatureName;
    }

    public String getGeomPropertyName() {
        return this.geomPropertyName;
    }

    public SortedSet<Generalization> getGeneralizations() {
        return this.generalizations;
    }

    public Generalization getGeneralizationForDistance(Double requestedDistance) {
        if (requestedDistance == null) {
            return null;
        }
        Generalization result = null;
        for (Generalization di : this.generalizations) {
            if (!(requestedDistance >= di.getDistance())) break;
            result = di;
        }
        return result;
    }

    public String getDataSourceName() {
        if (this.dataSourceName != null) {
            return this.dataSourceName;
        }
        return this.parent.getDataSourceName();
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceNameSpace() {
        if (this.dataSourceNameSpace != null) {
            return this.dataSourceNameSpace;
        }
        return this.parent.getDataSourceNameSpace();
    }

    public void setDataSourceNameSpace(String namespace) {
        this.dataSourceNameSpace = namespace;
    }

    public void validate() throws IOException {
        if (this.getDataSourceName() == null) {
            throw new IOException("Datasource name missing");
        }
        if (this.getFeatureName() == null) {
            throw new IOException("Feature name missing");
        }
        if (this.getBaseFeatureName() == null) {
            throw new IOException("Base feature name missing");
        }
        if (this.getGeomPropertyName() == null) {
            throw new IOException("Geometry property name missing");
        }
        for (Generalization di : this.getGeneralizations()) {
            di.validate();
        }
    }
}

