/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.data.WorldFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffException;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.adapters.GeoTiffIIOMetadataDecoder;
import org.geotools.gce.geotiff.adapters.GeoTiffMetadata2CRSAdapter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class GeoTiffReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private Logger LOGGER = Logging.getLogger((String)GeoTiffReader.class.toString());
    private static final TIFFImageReaderSpi readerSPI = new TIFFImageReaderSpi();
    private GeoTiffIIOMetadataDecoder metadata;
    private GeoTiffMetadata2CRSAdapter gtcs;
    private double noData = Double.NaN;

    public GeoTiffReader(Object input) throws DataSourceException {
        this(input, new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
    }

    public GeoTiffReader(Object input, Hints uHints) throws DataSourceException {
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (uHints != null) {
            uHints.remove((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
            this.hints.add((RenderingHints)uHints);
            this.hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        this.coverageName = "geotiff_coverage";
        if (input == null) {
            IOException ex = new IOException("GeoTiffReader:No source set to read this coverage.");
            throw new DataSourceException((Throwable)ex);
        }
        try {
            this.source = input;
            if (input instanceof URL) {
                URL sourceURL = (URL)input;
                if (sourceURL.getProtocol().equalsIgnoreCase("http") || sourceURL.getProtocol().equalsIgnoreCase("ftp")) {
                    try {
                        this.source = sourceURL.openStream();
                    }
                    catch (IOException e) {
                        new RuntimeException(e);
                    }
                } else if (sourceURL.getProtocol().equalsIgnoreCase("file")) {
                    this.source = DataUtilities.urlToFile((URL)sourceURL);
                }
            }
            this.closeMe = true;
            if (this.source instanceof InputStream || this.source instanceof ImageInputStream) {
                this.closeMe = false;
            }
            this.inStream = this.source instanceof ImageInputStream ? (ImageInputStream)this.source : ImageIO.createImageInputStream(this.source);
            if (this.inStream == null) {
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            this.getHRInfo(this.hints);
            this.coverageName = this.source instanceof File ? ((File)this.source).getName() : "geotiff_coverage";
            int dotIndex = this.coverageName.lastIndexOf(46);
            if (dotIndex != -1 && dotIndex != this.coverageName.length()) {
                this.coverageName = this.coverageName.substring(0, dotIndex);
            }
            if (this.closeMe) {
                this.inStream.close();
            }
        }
        catch (IOException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    private void getHRInfo(Hints hints) throws IOException, FactoryException, GeoTiffException, TransformException, MismatchedDimensionException, DataSourceException {
        ImageReader reader = readerSPI.createReaderInstance();
        reader.setInput(this.inStream);
        IIOMetadata iioMetadata = reader.getImageMetadata(0);
        CoordinateReferenceSystem foundCrs = null;
        boolean useWorldFile = false;
        try {
            this.metadata = new GeoTiffIIOMetadataDecoder(iioMetadata);
            this.gtcs = (GeoTiffMetadata2CRSAdapter)GeoTiffMetadata2CRSAdapter.get(hints);
            if (this.gtcs != null) {
                foundCrs = this.gtcs.createCoordinateSystem(this.metadata);
            } else {
                useWorldFile = true;
            }
            if (this.metadata.hasNoData()) {
                this.noData = this.metadata.getNoData();
            }
        }
        catch (IllegalArgumentException iae) {
            useWorldFile = true;
        }
        catch (UnsupportedOperationException uoe) {
            useWorldFile = true;
        }
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            this.LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
        } else {
            if (useWorldFile) {
                foundCrs = this.getCRS(this.source);
            }
            this.crs = foundCrs;
        }
        if (this.crs == null) {
            throw new DataSourceException("Coordinate Reference System is not available");
        }
        this.numOverviews = reader.getNumImages(true) - 1;
        int hrWidth = reader.getWidth(0);
        int hrHeight = reader.getHeight(0);
        Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
        this.originalGridRange = new GridEnvelope2D(actualDim);
        this.raster2Model = !useWorldFile && this.gtcs != null ? this.gtcs.getRasterToModel(this.metadata) : GeoTiffReader.parseWorldFile(this.source);
        if (this.raster2Model == null) {
            throw new DataSourceException("Raster to Model Transformation is not available");
        }
        AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
        tempTransform.translate(-0.5, -0.5);
        this.originalEnvelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)actualDim));
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.highestRes = new double[2];
        this.highestRes[0] = XAffineTransform.getScaleX0((AffineTransform)tempTransform);
        this.highestRes[1] = XAffineTransform.getScaleY0((AffineTransform)tempTransform);
        if (this.numOverviews >= 1) {
            this.overViewResolutions = new double[this.numOverviews][2];
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = this.highestRes[0] * (double)this.originalGridRange.getSpan(0) / (double)reader.getWidth(i + 1);
                this.overViewResolutions[i][1] = this.highestRes[1] * (double)this.originalGridRange.getSpan(1) / (double)reader.getHeight(i + 1);
            }
        } else {
            this.overViewResolutions = null;
        }
    }

    public Format getFormat() {
        return new GeoTiffFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        Integer imageChoice = new Integer(0);
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
        }
        catch (TransformException e) {
            new DataSourceException((Throwable)e);
        }
        Hints newHints = this.hints.clone();
        ParameterBlock pbjRead = new ParameterBlock();
        pbjRead.add(ImageIO.createImageInputStream(this.source));
        pbjRead.add(imageChoice);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(null);
        pbjRead.add(null);
        pbjRead.add(readP);
        pbjRead.add(readerSPI.createReaderInstance());
        RenderedOp coverageRaster = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
        int ssWidth = coverageRaster.getWidth();
        int ssHeight = coverageRaster.getHeight();
        if (this.LOGGER.isLoggable(Level.FINE)) {
            this.LOGGER.log(Level.FINE, "Coverage read: width = " + ssWidth + " height = " + ssHeight);
        }
        double scaleX = (double)this.originalGridRange.getSpan(0) / (1.0 * (double)ssWidth);
        double scaleY = (double)this.originalGridRange.getSpan(1) / (1.0 * (double)ssHeight);
        AffineTransform tempRaster2Model = new AffineTransform((AffineTransform)this.raster2Model);
        tempRaster2Model.concatenate(new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0));
        return this.createCoverage((PlanarImage)coverageRaster, (MathTransform)ProjectiveTransform.create((AffineTransform)tempRaster2Model));
    }

    public GeoTiffIIOMetadataDecoder getMetadata() {
        return this.metadata;
    }

    protected final GridCoverage2D createCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        Category noDataCategory = null;
        if (!Double.isNaN(this.noData)) {
            noDataCategory = new Category((CharSequence)Vocabulary.formatInternational((int)110), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)this.noData, (double)this.noData), NumberRange.create((double)this.noData, (double)this.noData));
        }
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            Category[] categories = null;
            if (noDataCategory != null) {
                categories = new Category[]{noDataCategory};
            }
            bands[i] = new GridSampleDimension((CharSequence)colorInterpretation.name(), categories, null).geophysics(true);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, this.crs, raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, (Envelope)new GeneralEnvelope((Envelope)this.originalEnvelope), bands, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem getCRS(Object source) {
        CoordinateReferenceSystem crs = null;
        if (source instanceof File || source instanceof URL && ((URL)source).getProtocol() == "file") {
            String sourceAsString;
            if (source instanceof File) {
                sourceAsString = ((File)source).getAbsolutePath();
            } else {
                String auth = ((URL)source).getAuthority();
                String path = ((URL)source).getPath();
                sourceAsString = auth != null && !auth.equals("") ? "//" + auth + path : path;
            }
            int index = sourceAsString.lastIndexOf(".");
            StringBuilder base = new StringBuilder(sourceAsString.substring(0, index)).append(".prj");
            File prjFile = new File(base.toString());
            if (prjFile.exists()) {
                PrjFileReader projReader = null;
                try {
                    FileChannel channel = new FileInputStream(prjFile).getChannel();
                    projReader = new PrjFileReader((ReadableByteChannel)channel);
                    crs = projReader.getCoordinateReferenceSystem();
                }
                catch (FileNotFoundException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                catch (FactoryException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                finally {
                    if (projReader != null) {
                        try {
                            projReader.close();
                        }
                        catch (IOException e) {
                            this.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        }
        return crs;
    }

    static MathTransform parseWorldFile(Object source) throws IOException {
        MathTransform raster2Model = null;
        if (source instanceof File) {
            File sourceFile = (File)source;
            String parentPath = sourceFile.getParent();
            String filename = sourceFile.getName();
            int i = filename.lastIndexOf(46);
            filename = i == -1 ? filename : filename.substring(0, i);
            String base = parentPath != null ? parentPath + File.separator + filename : filename;
            File file2Parse = new File(base + ".wld");
            if (file2Parse.exists()) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                raster2Model = reader.getTransform();
            } else {
                file2Parse = new File(base + ".tfw");
                if (file2Parse.exists()) {
                    WorldFileReader reader = new WorldFileReader(file2Parse);
                    raster2Model = reader.getTransform();
                }
            }
        }
        return raster2Model;
    }

    public int getGridCoverageCount() {
        return 1;
    }
}

