/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gridcoverage;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.gridcoverage.DefaultGridCoverageDataStore;
import org.geotools.data.gridcoverage.exception.DataAccessGridCoverageException;

public class GridCoverageDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a GridCoverage file");
    public static final DataAccessFactory.Param FORMATP = new DataAccessFactory.Param("format", String.class, "name of an AbstractGridFormat");

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        if (params == null) {
            throw new NullPointerException("params can't be null");
        }
        if (params.size() == 0) {
            throw new IllegalArgumentException("params can't be empty");
        }
        URL url = (URL)URLP.lookUp(params);
        AbstractGridFormat gridFormat = this.getFormat(params);
        if (gridFormat instanceof UnknownFormat) {
            throw new IOException("Could not find an appropriate AbstractGridFormat for parameters '" + params.toString() + "'");
        }
        AbstractGridCoverage2DReader reader = gridFormat.getReader((Object)url);
        try {
            return new DefaultGridCoverageDataStore(reader);
        }
        catch (DataAccessGridCoverageException e) {
            throw new IOException("Could not instantiate a datastore with reader '" + reader.toString() + "'");
        }
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected AbstractGridFormat getFormat(String formatName) {
        Set factories = GridFormatFinder.getAvailableFormats();
        for (GridFormatFactorySpi factory : factories) {
            AbstractGridFormat format = factory.createFormat();
            if (!format.getName().equalsIgnoreCase(formatName)) continue;
            return format;
        }
        return new UnknownFormat();
    }

    protected AbstractGridFormat getFormat(Map<String, Serializable> params) {
        URL url = null;
        try {
            url = (URL)URLP.lookUp(params);
        }
        catch (IOException e) {
            return new UnknownFormat();
        }
        try {
            String formatName = (String)FORMATP.lookUp(params);
            return this.getFormat(formatName);
        }
        catch (IOException ioe) {
            try {
                return GridFormatFinder.findFormat((Object)url);
            }
            catch (Exception e) {
                return new UnknownFormat();
            }
        }
    }

    public boolean canProcess(Map<String, Serializable> params) {
        if (params == null) {
            throw new NullPointerException("params can't be null");
        }
        if (params.size() == 0) {
            throw new IllegalArgumentException("params can't be empty");
        }
        AbstractGridFormat gridFormat = this.getFormat(params);
        return !(gridFormat instanceof UnknownFormat);
    }

    public String getDescription() {
        return "GridCoverage raster files";
    }

    public String getDisplayName() {
        return "GridCoverage";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, FORMATP};
    }

    public boolean isAvailable() {
        try {
            GridFormatFinder.class.getName();
            AbstractGridCoverage2DReader.class.getName();
            DefaultGridCoverageDataStore.class.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

