/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2008(c).
 * 
 * file: GridCoverageDataStore.java
 * created: 17/10/2008
 */
package org.geotools.data.gridcoverage;

import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.DataStore;
import org.geotools.data.gridcoverage.exception.DataAccessGridCoverageException;

/**
 * Specifies a {@link DataStore} object for accessing file-based raster data. In
 * practice, objects implementing this interface will contain a
 * {@link GridCoverageFeatureSource} and thus be capable of providing access to
 * a default {@link AbstractGridCoverage2DReader}.
 * 
 * @author milton
 * @since TDK 3.0.0
 */
public interface GridCoverageDataStore extends DataStore
{
    /**
     * Retrieves the coverage reader wrapped by the GridCoverageDataStore.
     * 
     * @return the reader, which cannot be null.
     * @throws DataAccessGridCoverageException if the coverage reader cannot be
     *             retrieved.
     * @since TDK 3.0.0
     */
    public AbstractGridCoverage2DReader getCoverageReader() throws DataAccessGridCoverageException;
}
