/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicReader.class);
    static final ExecutorService multiThreadedLoader = new ThreadPoolExecutor(4, 8, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    URL sourceURL;
    boolean expandMe;
    PathType pathType;
    String locationAttributeName = "location";
    private RasterManager rasterManager;
    int maxAllowedTiles = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();

    public int getGridCoverageCount() {
        return 1;
    }

    public void dispose() {
        super.dispose();
        this.rasterManager.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (uHints != null) {
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (this.hints.containsKey((Object)Hints.MAX_ALLOWED_TILES)) {
            this.maxAllowedTiles = (Integer)this.hints.get((Object)Hints.MAX_ALLOWED_TILES);
        }
        if (source == null) {
            IOException ex = new IOException("ImageMosaicReader:No source set to read this coverage.");
            if (!LOGGER.isLoggable(Level.WARNING)) throw new DataSourceException((Throwable)ex);
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            throw new DataSourceException((Throwable)ex);
        }
        this.source = source;
        this.sourceURL = ImageMosaicUtils.checkSource(source);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts File, URL or String. The string may describe a File or an URL");
        }
        ShapefileDataStore tileIndexStore = null;
        try {
            try {
                String[] typeNames;
                tileIndexStore = new ShapefileDataStore(this.sourceURL);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Connected mosaic reader to its data store " + this.sourceURL.toString());
                }
                if ((typeNames = tileIndexStore.getTypeNames()).length <= 0) {
                    throw new IllegalArgumentException("Problems when opening the index, no typenames for the schema are defined");
                }
                String typeName = typeNames[0];
                FeatureSource featureSource = tileIndexStore.getFeatureSource(typeName);
                SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
                Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
                if (tempCRS != null) {
                    this.crs = (CoordinateReferenceSystem)tempCRS;
                    LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT().toString());
                } else {
                    CoordinateReferenceSystem tempcrs = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
                    if (tempcrs == null) {
                        this.crs = AbstractGridFormat.getDefaultCRS();
                        LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
                    } else {
                        this.crs = tempcrs;
                    }
                }
                boolean retValue = this.loadProperties();
                if (!retValue) {
                    throw new DataSourceException("Unable to create reader for this mosaic.");
                }
                if (this.hints.containsKey((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE)) {
                    this.locationAttributeName = (String)this.hints.get((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE);
                }
                if (this.locationAttributeName == null) {
                    for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                        if (!attribute.getType().getBinding().equals(String.class)) continue;
                        this.locationAttributeName = attribute.getName().toString();
                    }
                }
                if (schema.getDescriptor(this.locationAttributeName) == null) {
                    throw new DataSourceException("The provided name for the location attribute is invalid.");
                }
                this.rasterManager = new RasterManager(this);
            }
            catch (Throwable e) {
                throw new DataSourceException(e);
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var13_16 = null;
            try {
                try {
                    if (tileIndexStore != null) {
                        tileIndexStore.dispose();
                    }
                    v0 = null;
                }
                catch (Throwable e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    v0 = null;
                }
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var16_22 = v0;
            tileIndexStore = null;
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            return;
        }
        try {}
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINE)) return;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return;
        }
        if (tileIndexStore == null) return;
        tileIndexStore.dispose();
    }

    private boolean loadProperties() {
        ImageMosaicUtils.MosaicConfigurationBean configuration = ImageMosaicUtils.loadPropertiesFile(this.sourceURL, this.crs, this.locationAttributeName);
        if (configuration == null) {
            return false;
        }
        this.originalEnvelope = new GeneralEnvelope((Envelope)configuration.getEnvelope2D());
        this.numOverviews = configuration.getLevelsNum() - 1;
        double[][] resolutions = configuration.getLevels();
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
        this.highestRes = new double[2];
        this.highestRes[0] = resolutions[0][0];
        this.highestRes[1] = resolutions[0][1];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        if (this.numOverviews > 0) {
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = resolutions[i + 1][0];
                this.overViewResolutions[i][1] = resolutions[i + 1][1];
            }
        }
        this.coverageName = configuration.getName();
        this.expandMe = configuration.isExpandToRGB();
        this.originalGridRange = new GridEnvelope2D(new Rectangle((int)Math.round(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.originalGridRange, (Envelope)this.originalEnvelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        this.raster2Model = geMapper.createTransform();
        this.pathType = configuration.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE;
        this.locationAttributeName = configuration.getLocationAttribute();
        return true;
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        Collection<GridCoverage2D> response;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            LOGGER.fine(new StringBuffer("Highest res ").append(this.highestRes[0]).append(" ").append(this.highestRes[1]).toString());
        }
        if (this.maxAllowedTiles != Integer.MAX_VALUE) {
            if (params != null) {
                boolean found = false;
                for (GeneralParameterValue pv : params) {
                    if (!pv.getDescriptor().getName().equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    GeneralParameterValue[] temp = new GeneralParameterValue[params.length + 1];
                    System.arraycopy(params, 0, temp, 0, params.length);
                    ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                    tempVal.setValue(this.maxAllowedTiles);
                    temp[params.length] = tempVal;
                }
            } else {
                ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                tempVal.setValue(this.maxAllowedTiles);
                params = new GeneralParameterValue[]{tempVal};
            }
        }
        if ((response = this.rasterManager.read(params)).isEmpty()) {
            return null;
        }
        return response.iterator().next();
    }

    Hints getHints() {
        return this.hints;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOvervies() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    String getName() {
        return this.coverageName;
    }
}

