/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.imagepyramid.ImagePyramidReader;
import org.geotools.gce.imagepyramid.Utils;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImagePyramidFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.imagepyramid");
    private static final String SUGGESTED_TILESIZE = "SUGGESTED_TILE_SIZE";
    public static final DefaultParameterDescriptor<String> SUGGESTED_TILE_SIZE = new DefaultParameterDescriptor("SUGGESTED_TILE_SIZE", String.class, null, (Object)"512,512");
    public static final String TILE_SIZE_SEPARATOR = ",";
    public static final ParameterDescriptor<Boolean> FADING = new DefaultParameterDescriptor("Fading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Color> INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("InputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Color> OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Integer> MAX_ALLOWED_TILES = new DefaultParameterDescriptor("MaxAllowedTiles", Integer.class, null, (Object)Integer.MAX_VALUE);
    public static final ParameterDescriptor<Boolean> ALLOW_MULTITHREADING = new DefaultParameterDescriptor("AllowMultithreading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor("BackgroundValues", double[].class, null, null);

    public ImagePyramidFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImagePyramid");
        info.put("description", "Image pyramidal plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ALLOW_MULTITHREADING, MAX_ALLOWED_TILES}));
        this.writeParameters = null;
    }

    public ImagePyramidReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin is a read only plugin!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object source, Hints hints) {
        if (source == null) {
            throw new NullPointerException("Null parameter provided to the accepts method of this ImagePyramidFormat");
        }
        try {
            String[] pair;
            PrjFileReader crsReader;
            URL sourceURL;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Accepts method of ImagePyramid with source" + source);
            }
            if ((sourceURL = Utils.checkSource(source, hints)) == null) {
                return false;
            }
            try {
                sourceURL.openStream().close();
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) return false;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                return false;
            }
            URL prjURL = DataUtilities.changeUrlExt((URL)sourceURL, (String)"prj");
            try {
                crsReader = new PrjFileReader(Channels.newChannel(prjURL.openStream()));
            }
            catch (FactoryException e) {
                return false;
            }
            CoordinateReferenceSystem tempcrs = crsReader.getCoordinateReferenceSystem();
            if (tempcrs == null) {
                tempcrs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.FINE, "Unable to find a CRS for this coverage, using a default one: " + tempcrs.toWKT());
            }
            Properties properties = new Properties();
            BufferedInputStream propertyStream = null;
            if (!sourceURL.getPath().endsWith(".properties")) {
                return false;
            }
            InputStream openStream = sourceURL.openStream();
            try {
                propertyStream = new BufferedInputStream(openStream);
                properties.load(propertyStream);
            }
            catch (Throwable e) {
                if (propertyStream != null) {
                    propertyStream.close();
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (openStream != null) {
                    openStream.close();
                }
            }
            String envelope = properties.getProperty("Envelope2D");
            if (envelope == null) {
                return false;
            }
            String[] pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                pair = pairs[i].split(TILE_SIZE_SEPARATOR);
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            int numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
            String levels = properties.getProperty("Levels");
            pairs = levels.split(" ");
            double[][] overViewResolutions = numOverviews >= 1 ? new double[numOverviews][2] : (double[][])null;
            pair = pairs[0].split(TILE_SIZE_SEPARATOR);
            double[] highestRes = new double[]{Double.parseDouble(pair[0]), Double.parseDouble(pair[1])};
            int i = 1;
            while (true) {
                if (i >= numOverviews + 1) {
                    if (properties.getProperty("Name") != null) return true;
                    return false;
                }
                pair = pairs[i].split(TILE_SIZE_SEPARATOR);
                overViewResolutions[i - 1][0] = Double.parseDouble(pair[0]);
                overViewResolutions[i - 1][1] = Double.parseDouble(pair[1]);
                ++i;
            }
        }
        catch (IOException e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
        catch (NumberFormatException e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImagePyramidReader getReader(Object source, Hints hints) {
        try {
            return new ImagePyramidReader(source, hints);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(new StringBuffer("impossible to get a reader for the provided source. The error is ").append(e.getLocalizedMessage()).toString());
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(new StringBuffer("impossible to get a reader for the provided source. The error is ").append(e.getLocalizedMessage()).toString());
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

