/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.FeatureTypeHandler;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureReader;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCTransactionState;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.BasicAttributeIO;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBC1DataStore
implements DataStore {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    public static final Map TYPE_MAPPINGS = new HashMap();
    private BasicAttributeIO basicAttributeIO;
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    private LockingManager lockingManager = this.createLockingManager();
    protected final JDBCDataStoreConfig config;
    protected FeatureTypeHandler typeHandler = null;
    protected String sqlNameEscape = "";
    protected boolean allowWriteOnVolatileFIDs;
    protected int transactionIsolation = 0;
    private static final Set BASE_HINTS;

    static {
        TYPE_MAPPINGS.put(new Integer(12), String.class);
        TYPE_MAPPINGS.put(new Integer(1), String.class);
        TYPE_MAPPINGS.put(new Integer(-1), String.class);
        TYPE_MAPPINGS.put(new Integer(-7), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(16), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(-6), Short.class);
        TYPE_MAPPINGS.put(new Integer(5), Short.class);
        TYPE_MAPPINGS.put(new Integer(4), Integer.class);
        TYPE_MAPPINGS.put(new Integer(-5), Long.class);
        TYPE_MAPPINGS.put(new Integer(7), Float.class);
        TYPE_MAPPINGS.put(new Integer(6), Double.class);
        TYPE_MAPPINGS.put(new Integer(8), Double.class);
        TYPE_MAPPINGS.put(new Integer(3), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(2), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(91), Date.class);
        TYPE_MAPPINGS.put(new Integer(92), Time.class);
        TYPE_MAPPINGS.put(new Integer(93), Timestamp.class);
        BASE_HINTS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(Hints.FEATURE_DETACHED)));
    }

    public JDBC1DataStore(JDBCDataStoreConfig config) throws IOException {
        this.config = config;
        this.typeHandler = this.getFeatureTypeHandler(config);
    }

    public String getSqlNameEscape() {
        return this.sqlNameEscape;
    }

    protected void setSqlNameEscape(String sqlNameEscape) {
        this.sqlNameEscape = sqlNameEscape;
    }

    protected FeatureTypeHandler getFeatureTypeHandler(JDBCDataStoreConfig config) throws IOException {
        return new FeatureTypeHandler(this, this.buildFIDMapperFactory(config), config.getTypeHandlerTimeout());
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new DefaultFIDMapperFactory();
    }

    public FIDMapper getFIDMapper(String tableName) throws IOException {
        return this.typeHandler.getFIDMapper(tableName);
    }

    protected LockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from " + this.getClass().getSimpleName());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    public String[] getTypeNames() throws IOException {
        return this.typeHandler.getTypeNames();
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.typeHandler.getSchema(typeName);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table creation not implemented");
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table modification not supported");
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        if (!this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            if (this.getLockingManager() != null) {
                return new JDBCFeatureLocking(this, this.getSchema(typeName));
            }
            return new JDBCFeatureStore(this, this.getSchema(typeName));
        }
        return new JDBCFeatureSource(this, this.getSchema(typeName));
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(SimpleFeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        SimpleFeatureType schemaType = this.getSchema(typeName);
        int compare = DataUtilities.compare((SimpleFeatureType)requestType, (SimpleFeatureType)schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader((FeatureType)requestType);
        }
        ReTypeFeatureReader reader = this.getFeatureReader((Query)query, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType, false);
        }
        return reader;
    }

    protected String[] attributeNames(SimpleFeatureType featureType, Filter filter) throws IOException {
        String typeName = featureType.getTypeName();
        SimpleFeatureType origional = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        if (featureType.getAttributeCount() == origional.getAttributeCount()) {
            return DataUtilities.attributeNames((SimpleFeatureType)featureType);
        }
        String[] typeAttributes = DataUtilities.attributeNames((SimpleFeatureType)featureType);
        String[] filterAttributes = DataUtilities.attributeNames((Filter)sqlBuilder.getPostQueryFilter(filter));
        if (filterAttributes == null || filterAttributes.length == 0) {
            return typeAttributes;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(typeAttributes));
        set.addAll(Arrays.asList(filterAttributes));
        if (set.size() == typeAttributes.length) {
            return typeAttributes;
        }
        return set.toArray(new String[set.size()]);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction trans) throws IOException {
        SimpleFeatureType schema;
        String[] propertyNames;
        String typeName = query.getTypeName();
        SimpleFeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo typeInfo = this.typeHandler.getFeatureTypeInfo(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter postFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        preFilter = (Filter)preFilter.accept((FilterVisitor)simplifier, null);
        postFilter = (Filter)postFilter.accept((FilterVisitor)simplifier, null);
        Filter originalFilter = query.getFilter();
        ((DefaultQuery)query).setFilter(preFilter);
        String[] requestedNames = this.propertyNames(query);
        if (this.allSameOrder(requestedNames, featureType)) {
            propertyNames = requestedNames;
        } else if (requestedNames.length <= featureType.getAttributeCount()) {
            String[] filterNames = DataUtilities.attributeNames((Filter)postFilter, (SimpleFeatureType)featureType);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(Arrays.asList(requestedNames));
            int i = 0;
            while (i < filterNames.length) {
                if (!list.contains(filterNames[i])) {
                    list.add(filterNames[i]);
                }
                ++i;
            }
            propertyNames = list.size() == requestedNames.length ? requestedNames : list.toArray(new String[list.size()]);
            try {
                typeInfo = new FeatureTypeInfo(typeInfo.getFeatureTypeName(), DataUtilities.createSubType((SimpleFeatureType)typeInfo.getSchema(), (String[])propertyNames), typeInfo.getFIDMapper());
            }
            catch (SchemaException e1) {
                throw new DataSourceException("Could not create subtype", (Throwable)e1);
            }
        } else {
            throw new DataSourceException(String.valueOf(typeName) + " does not contain requested properties:" + query);
        }
        AttributeDescriptor[] attrTypes = null;
        try {
            attrTypes = this.getAttributeTypes(typeName, propertyNames, query.getHints());
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(propertyNames) + ", " + "FeatureType: " + featureType, (Throwable)schemaException);
        }
        String sqlQuery = this.constructQuery(query, attrTypes);
        LOGGER.fine(sqlQuery);
        ((DefaultQuery)query).setFilter(originalFilter);
        QueryData queryData = this.executeQuery(typeInfo, typeName, sqlQuery, trans, false, query.getHints());
        try {
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.setName(typeName);
            ftb.addAll(attrTypes);
            ftb.setNamespaceURI(this.getNameSpace());
            schema = ftb.buildFeatureType();
        }
        catch (FactoryRegistryException e) {
            throw new DataSourceException("Schema Factory Error when creating schema for FeatureReader", (Throwable)e);
        }
        ReTypeFeatureReader reader = this.createFeatureReader(schema, postFilter, queryData);
        try {
            SimpleFeatureType requestType = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])requestedNames);
            if (!FeatureTypes.equalsExact((SimpleFeatureType)requestType, (SimpleFeatureType)((SimpleFeatureType)reader.getFeatureType()))) {
                reader = new ReTypeFeatureReader(reader, requestType, false);
            }
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Could not handle query", (Throwable)schemaException);
        }
        return reader;
    }

    private String constructQuery(Query query, AttributeDescriptor[] attrTypes) throws IOException, DataSourceException {
        String sqlQuery;
        String typeName = query.getTypeName();
        SQLBuilder sqlBuilder = this.getSqlBuilder(query.getTypeName());
        sqlBuilder.setHints(query.getHints());
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        FIDMapper mapper = this.getFIDMapper(typeName);
        try {
            LOGGER.fine("calling sql builder with filter " + preFilter);
            if (query.getFilter() == Filter.EXCLUDE) {
                StringBuffer buf = new StringBuffer("SELECT ");
                sqlBuilder.sqlColumns(buf, mapper, attrTypes);
                sqlBuilder.sqlFrom(buf, typeName);
                buf.append(" WHERE '1' = '0'");
                sqlQuery = buf.toString();
            } else {
                Integer offset = query.getStartIndex();
                Integer limit = null;
                if (query.getMaxFeatures() != Integer.MAX_VALUE) {
                    limit = new Integer(query.getMaxFeatures());
                }
                sqlQuery = sqlBuilder.buildSQLQuery(typeName, mapper, attrTypes, preFilter, query.getSortBy(), offset, limit);
            }
            LOGGER.fine("sql is " + sqlQuery);
        }
        catch (SQLEncoderException e) {
            throw new DataSourceException("Error building SQL Query", (Throwable)e);
        }
        return sqlQuery;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(SimpleFeatureType schema, Filter postFilter, QueryData queryData) throws IOException {
        if (postFilter == Filter.EXCLUDE) {
            return new EmptyFeatureReader((FeatureType)schema);
        }
        JDBCFeatureReader fReader = this.getJDBCFeatureReader(queryData);
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            fReader = new FilteringFeatureReader((FeatureReader)fReader, postFilter);
        }
        return fReader;
    }

    protected JDBCFeatureReader getJDBCFeatureReader(QueryData queryData) throws IOException {
        return new JDBCFeatureReader(queryData);
    }

    protected AttributeIO getAttributeIO(AttributeDescriptor type) {
        if (this.basicAttributeIO == null) {
            this.basicAttributeIO = new BasicAttributeIO();
        }
        return this.basicAttributeIO;
    }

    protected abstract AttributeIO getGeometryAttributeIO(AttributeDescriptor var1, QueryData var2) throws IOException;

    protected QueryData executeQuery(FeatureTypeInfo featureTypeInfo, String tableName, String sqlQuery, Transaction transaction, boolean forWrite) throws IOException {
        return this.executeQuery(featureTypeInfo, tableName, sqlQuery, transaction, forWrite, null);
    }

    protected QueryData executeQuery(FeatureTypeInfo featureTypeInfo, String tableName, String sqlQuery, Transaction transaction, boolean forWrite, Hints hints) throws IOException {
        LOGGER.fine("About to execute query: " + sqlQuery);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(transaction);
            this.setAutoCommit(forWrite, conn);
            statement = conn.createStatement(this.getResultSetType(forWrite), this.getConcurrency(forWrite));
            statement.setFetchSize(1000);
            rs = statement.executeQuery(sqlQuery);
            return new QueryData(featureTypeInfo, this, conn, statement, rs, transaction, hints);
        }
        catch (SQLException e) {
            String msg = "Error Performing SQL query: " + sqlQuery;
            LOGGER.log(Level.SEVERE, msg, e);
            JDBCUtils.close(rs);
            JDBCUtils.close(statement);
            JDBCUtils.close(conn, transaction, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }

    protected void setAutoCommit(boolean forWrite, Connection conn) throws SQLException {
        if (!forWrite) {
            conn.setAutoCommit(false);
        }
    }

    protected int getResultSetType(boolean forWrite) {
        return 1003;
    }

    protected int getConcurrency(boolean forWrite) {
        if (forWrite) {
            return 1008;
        }
        return 1007;
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SimpleFeatureType schema = this.getSchema(typeName);
        SQLEncoder encoder = new SQLEncoder();
        encoder.setFeatureType(schema);
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        return new DefaultSQLBuilder(encoder, schema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Transaction transaction) throws IOException {
        if (transaction != Transaction.AUTO_COMMIT) {
            JDBCTransactionState state;
            Transaction transaction2 = transaction;
            synchronized (transaction2) {
                state = (JDBCTransactionState)transaction.getState((Object)this);
                if (state == null) {
                    try {
                        Connection conn = this.createConnection();
                        conn.setAutoCommit(this.requireAutoCommit());
                        if (this.getTransactionIsolation() != 0) {
                            conn.setTransactionIsolation(this.getTransactionIsolation());
                        }
                        state = new JDBCTransactionState(conn);
                        transaction.putState((Object)this, (Transaction.State)state);
                    }
                    catch (SQLException eep) {
                        throw new DataSourceException("Connection failed:" + eep, (Throwable)eep);
                    }
                }
            }
            return state.getConnection();
        }
        try {
            return this.createConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Connection failed:" + sqle, (Throwable)sqle);
        }
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int value) {
        this.transactionIsolation = value;
    }

    protected boolean requireAutoCommit() {
        return false;
    }

    protected abstract Connection createConnection() throws SQLException;

    protected boolean allowTable(String tablename) {
        return true;
    }

    protected FIDMapper buildFIDMapper(String typeName, FIDMapperFactory factory) throws IOException {
        Connection conn = null;
        try {
            FIDMapper mapper;
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            FIDMapper fIDMapper = mapper = factory.getMapper(null, this.config.getDatabaseSchemaName(), typeName, conn);
            return fIDMapper;
        }
        finally {
            JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SimpleFeatureType buildSchema(String typeName, FIDMapper mapper) throws IOException {
        SimpleFeatureType simpleFeatureType;
        int NAME_COLUMN = 4;
        int TYPE_NAME = 6;
        Connection conn = null;
        ResultSet tableInfo = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ArrayList<AttributeDescriptor> attributeTypes = new ArrayList<AttributeDescriptor>();
            tableInfo = dbMetaData.getColumns(null, this.config.getDatabaseSchemaName(), typeName, "%");
            boolean tableInfoFound = false;
            while (true) {
                if (!tableInfo.next()) {
                    if (tableInfoFound) break;
                    throw new SchemaNotFoundException(typeName);
                }
                tableInfoFound = true;
                try {
                    AttributeDescriptor attributeType;
                    String columnName = tableInfo.getString(4);
                    if (!mapper.returnFIDColumnsAsAttributes()) {
                        boolean isPresent = false;
                        int i = 0;
                        while (i < mapper.getColumnCount()) {
                            if (columnName.equalsIgnoreCase(mapper.getColumnName(i))) {
                                isPresent = true;
                                break;
                            }
                            ++i;
                        }
                        if (isPresent) continue;
                    }
                    if ((attributeType = this.buildAttributeType(tableInfo)) != null) {
                        attributeTypes.add(attributeType);
                        continue;
                    }
                    LOGGER.finest("Unknown SQL Type: " + tableInfo.getString(6));
                }
                catch (DataSourceException dse) {
                    String msg = "Error building attribute type. The column will be ignored";
                    LOGGER.log(Level.WARNING, msg, dse);
                }
            }
            AttributeDescriptor[] types = attributeTypes.toArray(new AttributeDescriptor[0]);
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.setName(typeName);
            ftb.addAll(types);
            ftb.setNamespaceURI(this.getNameSpace());
            simpleFeatureType = ftb.buildFeatureType();
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                conn = null;
                throw new DataSourceException("SQL Error building FeatureType for " + typeName + " " + sqlException.getMessage(), (Throwable)sqlException);
                catch (FactoryRegistryException e) {
                    throw new DataSourceException("Error creating FeatureType " + typeName, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(tableInfo);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close(tableInfo);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return simpleFeatureType;
    }

    protected AttributeDescriptor buildAttributeType(ResultSet rs) throws IOException {
        boolean nillable;
        Class type;
        String columnName;
        block8: {
            try {
                int COLUMN_NAME = 4;
                int DATA_TYPE = 5;
                int NULLABLE = 11;
                int LENGTH = 7;
                columnName = rs.getString(4);
                int dataType = rs.getInt(5);
                type = (Class)TYPE_MAPPINGS.get(new Integer(dataType));
                int nullCode = rs.getInt(11);
                nillable = true;
                switch (nullCode) {
                    case 0: {
                        nillable = false;
                        break;
                    }
                    case 1: {
                        nillable = true;
                        break;
                    }
                    case 2: {
                        nillable = true;
                    }
                }
                if (type != null) break block8;
                return null;
            }
            catch (SQLException e) {
                throw new IOException("SQL exception occurred: " + e.getMessage());
            }
        }
        int min = nillable ? 0 : 1;
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.setName(columnName);
        atb.setBinding(type);
        atb.setMinOccurs(min);
        atb.setMaxOccurs(1);
        return atb.buildDescriptor(columnName);
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        return -1;
    }

    protected String determineFidColumnName(String typeName) throws IOException {
        String fidColumnName;
        block6: {
            int NAME_COLUMN = 4;
            fidColumnName = null;
            ResultSet rs = null;
            Connection conn = null;
            try {
                try {
                    conn = this.getConnection(Transaction.AUTO_COMMIT);
                    DatabaseMetaData dbMetadata = conn.getMetaData();
                    rs = dbMetadata.getPrimaryKeys(null, null, typeName);
                    if (rs.next()) {
                        fidColumnName = rs.getString(4);
                    }
                }
                catch (SQLException sqlException) {
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                    conn = null;
                    LOGGER.warning("Could not find the primary key - using the default");
                    JDBCUtils.close(rs);
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
            JDBCUtils.close(rs);
            JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        }
        return fidColumnName;
    }

    public URI getNameSpace() {
        try {
            if (this.config.getNamespace() != null) {
                return new URI(this.config.getNamespace());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.warning("Could not use namespace " + this.config.getNamespace() + " - " + e.getMessage());
            return null;
        }
        return null;
    }

    public String getDatabaseSchemaName() {
        return this.config.getDatabaseSchemaName();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getFeatureWriter(typeName, (Filter)Filter.EXCLUDE, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        String sqlQuery;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean Transaction.AUTO_COMMIT");
        }
        SimpleFeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        LOGGER.fine("getting feature writer for " + typeName + ": " + info);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(filter);
        Filter postFilter = sqlBuilder.getPostQueryFilter(filter);
        DefaultQuery query = new DefaultQuery(typeName, preFilter);
        try {
            sqlQuery = this.constructQuery((Query)query, this.getAttributeTypes(typeName, this.propertyNames((Query)query), null));
        }
        catch (SchemaException e) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(query.getPropertyNames()) + ", " + "FeatureType: " + featureType, (Throwable)e);
        }
        QueryData queryData = this.executeQuery(this.typeHandler.getFeatureTypeInfo(typeName), typeName, sqlQuery, transaction, true, null);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.createFeatureReader(info.getSchema(), postFilter, queryData);
        JDBCFeatureWriter writer = this.createFeatureWriter(reader, queryData);
        if (this.getLockingManager() != null && this.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager inProcess = (InProcessLockingManager)this.getLockingManager();
            writer = inProcess.checkedWriter((FeatureWriter)writer, transaction);
        }
        return writer;
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        JDBCFeatureWriter featureWriter = new JDBCFeatureWriter(reader, queryData);
        return featureWriter;
    }

    protected String[] propertyNames(Query query) throws IOException {
        String[] names = query.getPropertyNames();
        if (names == null || query.retrieveAllProperties()) {
            String typeName = query.getTypeName();
            SimpleFeatureType schema = this.getSchema(typeName);
            names = new String[schema.getAttributeCount()];
            int i = 0;
            while (i < schema.getAttributeCount()) {
                names[i] = schema.getDescriptor(i).getLocalName();
                ++i;
            }
        }
        return names;
    }

    protected final AttributeDescriptor[] getAttributeTypes(String typeName, String[] propertyNames, Hints hints) throws IOException, SchemaException {
        SimpleFeatureType schema = this.getSchema(typeName);
        AttributeDescriptor[] types = new AttributeDescriptor[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            types[i] = schema.getDescriptor(propertyNames[i]);
            if (types[i] == null) {
                throw new SchemaException(String.valueOf(typeName) + " does not contain requested " + propertyNames[i] + " attribute");
            }
            if (hints != null && hints.containsKey((Object)Hints.FEATURE_2D) && Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D)) && types[i] instanceof GeometryDescriptor && !Integer.valueOf(2).equals(types[i].getUserData().get(Hints.COORDINATE_DIMENSION))) {
                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                builder.init(types[i]);
                builder.userData((Object)Hints.COORDINATE_DIMENSION, (Object)2);
                GeometryType type = builder.buildGeometryType();
                types[i] = builder.buildDescriptor(types[i].getName(), type);
            }
            ++i;
        }
        return types;
    }

    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    public void setFIDMapper(String featureTypeName, FIDMapper fidMapper) {
        this.typeHandler.setFIDMapper(featureTypeName, fidMapper);
    }

    public FIDMapperFactory getFIDMapperFactory() {
        return this.typeHandler.getFIDMapperFactory();
    }

    public void setFIDMapperFactory(FIDMapperFactory fmFactory) throws UnsupportedOperationException {
        this.typeHandler.setFIDMapperFactory(fmFactory);
    }

    public boolean allSameOrder(String[] requestedNames, SimpleFeatureType ft) {
        if (requestedNames.length != ft.getAttributeCount()) {
            return false;
        }
        int t = 0;
        while (t < requestedNames.length) {
            if (!requestedNames[t].equals(ft.getDescriptor(t).getLocalName())) {
                return false;
            }
            ++t;
        }
        return true;
    }

    public Envelope getEnvelope(String typeName) {
        return null;
    }

    public Set getSupportedHints() {
        return BASE_HINTS;
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            names.add((Name)new NameImpl(typeName));
            ++n2;
        }
        return names;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }
}

