/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.FeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCFeatureCollection
extends DefaultFeatureResults {
    public boolean isOptimized = false;

    public JDBCFeatureCollection(JDBCFeatureSource source, Query query) throws IOException {
        super((SimpleFeatureSource)source, query);
    }

    JDBC1DataStore getDataStore() {
        return (JDBC1DataStore)this.featureSource.getDataStore();
    }

    JDBCFeatureSource getFeatureSource() {
        return (JDBCFeatureSource)this.featureSource;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        MaxFeatureReader reader = this.getDataStore().getFeatureReader(this.query, this.getTransaction());
        int maxFeatures = this.query.getMaxFeatures();
        if (maxFeatures != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader(reader, maxFeatures);
        }
        if (this.transform != null) {
            reader = new ReprojectFeatureReader((FeatureReader)reader, this.getSchema(), this.transform);
        }
        return reader;
    }

    public int getCount() throws IOException {
        int count = this.getFeatureSource().count(this.query, this.getTransaction());
        if (count != -1) {
            int maxFeatures = this.query.getMaxFeatures();
            return count < maxFeatures ? count : maxFeatures;
        }
        return super.getCount();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        try {
            if (progress == null) {
                progress = new NullProgressListener();
            }
            if (visitor instanceof MinVisitor) {
                progress.started();
                MinVisitor minCalc = (MinVisitor)visitor;
                Object min = this.min(minCalc.getExpression());
                if (min != null) {
                    minCalc.setValue(min);
                    this.isOptimized = true;
                    progress.complete();
                    return;
                }
                progress.warningOccurred("JDBCFeatureCollection.accepts(min,)", null, "Optimization attempt returned null");
            } else if (visitor instanceof MaxVisitor) {
                progress.started();
                MaxVisitor maxCalc = (MaxVisitor)visitor;
                Object max = this.max(maxCalc.getExpression());
                if (max != null) {
                    maxCalc.setValue(max);
                    this.isOptimized = true;
                    progress.complete();
                    return;
                }
                progress.warningOccurred("JDBCFeatureCollection.accepts(max,)", null, "Optimization attempt returned null");
            } else if (!(visitor instanceof MedianVisitor)) {
                if (visitor instanceof SumVisitor) {
                    progress.started();
                    SumVisitor sumCalc = (SumVisitor)visitor;
                    Object sum = this.sum(sumCalc.getExpression());
                    if (sum != null) {
                        sumCalc.setValue(sum);
                        this.isOptimized = true;
                        progress.complete();
                        return;
                    }
                    progress.warningOccurred("JDBCFeatureCollection.accepts(sum,)", null, "Optimization attempt returned null");
                } else if (visitor instanceof CountVisitor) {
                    progress.started();
                    CountVisitor countCalc = (CountVisitor)visitor;
                    Object count = this.count(null);
                    if (count != null) {
                        countCalc.setValue(((Number)count).intValue());
                        this.isOptimized = true;
                        progress.complete();
                        return;
                    }
                    progress.warningOccurred("JDBCFeatureCollection.accepts(count,)", null, "Optimization attempt returned null");
                } else if (visitor instanceof AverageVisitor) {
                    progress.started();
                    AverageVisitor averageCalc = (AverageVisitor)visitor;
                    Object sum = this.sum(averageCalc.getExpression());
                    Object count = this.count(null);
                    if (sum != null && count != null) {
                        averageCalc.setValue(((Number)count).intValue(), sum);
                        this.isOptimized = true;
                        progress.complete();
                        return;
                    }
                    progress.warningOccurred("JDBCFeatureCollection.accepts(average,)", null, "Optimization attempt returned null");
                } else if (visitor instanceof UniqueVisitor) {
                    progress.started();
                    UniqueVisitor uniqueCalc = (UniqueVisitor)visitor;
                    Object unique = this.unique(uniqueCalc.getExpression());
                    if (unique != null) {
                        uniqueCalc.setValue(unique);
                        this.isOptimized = true;
                        progress.complete();
                        return;
                    }
                    progress.warningOccurred("JDBCFeatureCollection.accepts(unique,)", null, "Optimization attempt returned null");
                }
            }
            this.isOptimized = false;
            super.accepts(visitor, progress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Connection getConnection() throws IOException {
        return this.getDataStore().getConnection(this.getFeatureSource().getTransaction());
    }

    Object min(Expression expression) throws IOException {
        return this.aggregate("MIN", expression);
    }

    Object max(Expression expression) throws IOException {
        return this.aggregate("MAX", expression);
    }

    Object median(Expression expression) throws IOException {
        return this.aggregate("MEDIAN", expression);
    }

    Object sum(Expression expression) throws IOException {
        return this.aggregate("SUM", expression);
    }

    Object count(Expression expression) throws IOException {
        return this.aggregate("COUNT", expression);
    }

    Object average(Expression expression) throws IOException {
        return this.aggregate("AVERAGE", expression);
    }

    Object unique(Expression expression) throws IOException {
        return this.aggregate("DISTINCT", expression);
    }

    Object aggregate(String aggregate, Expression expression) throws IOException {
        Filter filter = this.query.getFilter();
        if (Filter.EXCLUDE.equals(filter)) {
            return null;
        }
        JDBC1DataStore jdbc = this.getDataStore();
        SQLBuilder sqlBuilder = jdbc.getSqlBuilder(this.getSchema().getTypeName());
        Filter postFilter = sqlBuilder.getPostQueryFilter(this.query.getFilter());
        if (postFilter != null && !Filter.INCLUDE.equals(postFilter)) {
            return null;
        }
        Connection conn = null;
        ResultSet results = null;
        Statement statement = null;
        try {
            conn = jdbc.getConnection(this.getFeatureSource().getTransaction());
            String typeName = this.getSchema().getTypeName();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            sql.append(aggregate);
            sql.append("(");
            if (expression == null) {
                sql.append("*");
            } else {
                expression = (Expression)expression.accept((ExpressionVisitor)new ExpressionSimplifier(), null);
                sqlBuilder.encode(sql, expression);
            }
            sql.append(") AS rslt");
            sqlBuilder.sqlFrom(sql, typeName);
            sqlBuilder.sqlWhere(sql, filter);
            statement = conn.createStatement();
            results = statement.executeQuery(sql.toString());
            if (results == null) {
                return null;
            }
            results.next();
            Object answer = results.getObject("rslt");
            results.next();
            if (results.isAfterLast()) {
                Object object = answer;
                return object;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(answer);
            while (!results.isAfterLast()) {
                list.add(results.getObject("rslt"));
                results.next();
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(conn, this.getFeatureSource().getTransaction(), sqlException);
            conn = null;
            throw new DataSourceException("Could not calculate " + aggregate + " with " + this.query.getHandle(), (Throwable)sqlException);
        }
        catch (SQLEncoderException e) {
            return null;
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            JDBCUtils.close(conn, this.getFeatureSource().getTransaction(), null);
        }
    }

    class ExpressionSimplifier
    extends DuplicatingFilterVisitor {
        ExpressionSimplifier() {
        }

        public Object visit(PropertyName expression, Object extraData) {
            String xpath = expression.getPropertyName();
            if (xpath.startsWith("featureMembers/*/")) {
                xpath = xpath.substring(17);
            } else if (xpath.startsWith("featureMember/*/")) {
                xpath = xpath.substring(16);
            }
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            PropertyName simplified = ff.property(xpath);
            return simplified;
        }
    }
}

