/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import org.geotools.data.jdbc.fidmapper.FIDMapper;

public abstract class AbstractFIDMapper
implements FIDMapper {
    protected boolean[] autoIncrement = new boolean[1];
    protected int[] colDecimalDigits = new int[1];
    protected String[] colNames = new String[1];
    protected int[] colSizes = new int[1];
    protected int[] colTypes = new int[1];
    protected String tableName = null;
    protected String tableSchemaName = null;
    protected boolean returnFIDColumnsAsAttributes = false;

    public AbstractFIDMapper() {
    }

    public AbstractFIDMapper(String tableSchemaName, String tableName) {
        this.tableSchemaName = tableSchemaName;
        this.tableName = tableName;
    }

    public int getColumnCount() {
        if (this.colNames[0] == null) {
            return 0;
        }
        return this.colNames.length;
    }

    protected int getColumnDecimalDigits() {
        return this.getColumnDecimalDigits(0);
    }

    public int getColumnDecimalDigits(int colIndex) {
        if (colIndex > 0 && colIndex < this.getColumnCount()) {
            return this.colDecimalDigits[colIndex];
        }
        return 0;
    }

    protected String getColumnName() {
        return this.getColumnName(0);
    }

    public String getColumnName(int colIndex) {
        if (colIndex >= 0 && colIndex < this.getColumnCount()) {
            return this.colNames[colIndex];
        }
        return null;
    }

    protected int getColumnSize() {
        return this.getColumnSize(0);
    }

    public int getColumnSize(int colIndex) {
        if (colIndex >= 0 && colIndex < this.getColumnCount()) {
            return this.colSizes[colIndex];
        }
        return -1;
    }

    protected int getColumnType() {
        return this.getColumnType(0);
    }

    public int getColumnType(int colIndex) {
        if (colIndex >= 0 && colIndex < this.getColumnCount()) {
            return this.colTypes[colIndex];
        }
        throw new ArrayIndexOutOfBoundsException(colIndex);
    }

    public boolean hasAutoIncrementColumns() {
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this.isAutoIncrement(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initSupportStructures() {
    }

    protected boolean isAutoIncrement() {
        return this.isAutoIncrement(0);
    }

    public boolean isAutoIncrement(int colIndex) {
        if (colIndex >= 0 && colIndex < this.getColumnCount()) {
            return this.autoIncrement[colIndex];
        }
        return true;
    }

    public boolean isVolatile() {
        return false;
    }

    public boolean returnFIDColumnsAsAttributes() {
        return this.returnFIDColumnsAsAttributes;
    }

    protected void setInfo(String colName, int colType, int colSize, int colDecimalDigits, boolean autoIncrement) {
        this.colNames[0] = colName;
        this.colTypes[0] = colType;
        this.colSizes[0] = colSize;
        this.colDecimalDigits[0] = colDecimalDigits;
        this.autoIncrement[0] = autoIncrement;
    }

    public String toString() {
        String mapperName = this.getClass().toString();
        String colInfo = "";
        if (this.getColumnCount() > 0) {
            colInfo = String.valueOf(this.getColumnName(0)) + ":" + this.getColumnType(0) + ":" + this.getColumnSize(0) + ":" + this.getColumnDecimalDigits(0);
        }
        String s = String.valueOf(mapperName) + ":" + this.getColumnCount() + ":" + colInfo + ":" + this.returnFIDColumnsAsAttributes() + ":" + this.hasAutoIncrementColumns() + ":";
        return s;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }
}

