/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.RenderingHints;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBC3DTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBC3DTest
extends JDBCTestSupport {
    protected static final String LINE3D = "line3d";
    protected static final String POLY3D = "poly3d";
    protected static final String POINT3D = "point3d";
    protected static final String ID = "id";
    protected static final String GEOM = "geom";
    protected static final String NAME = "name";
    protected static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType poly3DType;
    protected SimpleFeatureType line3DType;
    protected CoordinateReferenceSystem epsg4326;

    protected abstract JDBC3DTestSetup createTestSetup();

    protected void setUp() throws Exception {
        super.setUp();
        this.line3DType = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + this.tname(LINE3D)), (String)(this.aname(ID) + ":0," + this.aname(GEOM) + ":LineString:srid=4326," + this.aname(NAME) + ":String"));
        this.line3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.poly3DType = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + this.tname(POLY3D)), (String)(this.aname(ID) + ":0," + this.aname(GEOM) + ":Polygon:srid=4326," + this.aname(NAME) + ":String"));
        this.poly3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.epsg4326 = CRS.decode((String)"EPSG:4326");
    }

    protected Integer getNativeSRID() {
        return new Integer(4326);
    }

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.dataStore.getSchema(this.tname(LINE3D));
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        JDBC3DTest.assertEquals((Object)new Integer(4326), (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        JDBC3DTest.assertEquals((Object)this.getNativeSRID(), schema.getGeometryDescriptor().getUserData().get("nativeSRID"));
    }

    public void testReadPoint() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(POINT3D)).getFeatures();
        FeatureIterator fr = fc.features();
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        Point p = (Point)((SimpleFeature)fr.next()).getDefaultGeometry();
        JDBC3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 1.0).equals((Object)p.getCoordinate()));
        fr.close();
    }

    public void testReadLine() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(LINE3D)).getFeatures();
        FeatureIterator fr = fc.features();
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        LineString ls = (LineString)((SimpleFeature)fr.next()).getDefaultGeometry();
        JDBC3DTest.assertEquals((int)4, (int)ls.getCoordinates().length);
        JDBC3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 0.0).equals3D(ls.getCoordinateN(0)));
        JDBC3DTest.assertTrue((boolean)new Coordinate(2.0, 2.0, 0.0).equals3D(ls.getCoordinateN(1)));
        JDBC3DTest.assertTrue((boolean)new Coordinate(4.0, 2.0, 1.0).equals3D(ls.getCoordinateN(2)));
        JDBC3DTest.assertTrue((boolean)new Coordinate(5.0, 1.0, 1.0).equals3D(ls.getCoordinateN(3)));
        fr.close();
    }

    public void testWriteLine() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0, 0.0), new Coordinate(1.0, 1.0, 1.0)});
        SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.line3DType, (Object[])new Object[]{2, ls, "l3"}, null);
        FeatureStore fs = (FeatureStore)this.dataStore.getFeatureSource(this.tname(LINE3D), Transaction.AUTO_COMMIT);
        List fids = fs.addFeatures(DataUtilities.collection((SimpleFeature)newFeature));
        FeatureIterator fi = fs.getFeatures((Filter)FF.id(new HashSet(fids))).features();
        JDBC3DTest.assertTrue((boolean)fi.hasNext());
        SimpleFeature f = (SimpleFeature)fi.next();
        JDBC3DTest.assertTrue((boolean)ls.equals((Geometry)f.getDefaultGeometry()));
        fi.close();
    }

    public void testCreateSchemaAndInsert() throws Exception {
        this.dataStore.createSchema(this.poly3DType);
        SimpleFeatureType actualSchema = this.dataStore.getSchema(this.tname(POLY3D));
        this.assertFeatureTypesEqual(this.poly3DType, actualSchema);
        JDBC3DTest.assertEquals((Object)this.getNativeSRID(), actualSchema.getGeometryDescriptor().getUserData().get("nativeSRID"));
        GeometryFactory gf = new GeometryFactory();
        LinearRing shell = gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0, 0.0), new Coordinate(1.0, 1.0, 1.0), new Coordinate(1.0, 0.0, 1.0), new Coordinate(0.0, 0.0, 0.0)});
        Polygon poly = gf.createPolygon(shell, null);
        FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname(POLY3D), Transaction.AUTO_COMMIT);
        SimpleFeature f = (SimpleFeature)fw.next();
        f.setAttribute(this.aname(ID), (Object)0);
        f.setAttribute(this.aname(GEOM), (Object)poly);
        f.setAttribute(this.aname(NAME), (Object)"3dpolygon!");
        fw.write();
        fw.close();
        FeatureReader fr = this.dataStore.getFeatureReader((Query)new DefaultQuery(this.tname(POLY3D)), Transaction.AUTO_COMMIT);
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        f = (SimpleFeature)fr.next();
        JDBC3DTest.assertTrue((boolean)poly.equals((Geometry)f.getDefaultGeometry()));
        fr.close();
    }

    public void testBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(LINE3D)).getBounds();
        Envelope expected = new Envelope(1.0, 5.0, 0.0, 4.0);
        JDBC3DTest.assertEquals((Object)expected, (Object)env);
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)env.getCoordinateReferenceSystem());
    }

    public void testRendererBehaviour() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(LINE3D));
        JDBC3DTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        DefaultQuery q = new DefaultQuery(this.tname(LINE3D));
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        ContentFeatureCollection fc = fs.getFeatures((Query)q);
        FeatureType fcSchema = fc.getSchema();
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)fcSchema.getCoordinateReferenceSystem());
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)fcSchema.getGeometryDescriptor().getCoordinateReferenceSystem());
        LineString expected = new GeometryFactory().createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(4.0, 2.0), new Coordinate(5.0, 1.0)});
        FeatureReader fr = this.dataStore.getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)((SimpleFeatureType)fr.getFeatureType()).getCoordinateReferenceSystem());
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)((SimpleFeatureType)fr.getFeatureType()).getGeometryDescriptor().getCoordinateReferenceSystem());
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBC3DTest.assertTrue((boolean)expected.equals((Geometry)f.getDefaultGeometry()));
        fr.close();
    }
}

