/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.SQLException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    SimpleFeatureType featureType;
    QueryData queryData;
    Object[] fidAttributes;
    SimpleFeatureBuilder builder;

    public JDBCFeatureReader(QueryData queryData) throws IOException {
        this.queryData = queryData;
        this.fidAttributes = new Object[queryData.getMapper().getColumnCount()];
        this.builder = new SimpleFeatureBuilder(queryData.getFeatureType());
    }

    public void close() throws IOException {
        this.close(null);
    }

    void close(SQLException sqlException) {
        this.queryData.close(sqlException);
    }

    public boolean hasNext() throws IOException {
        if (this.queryData.isClosed()) {
            throw new IOException("Reader is closed");
        }
        return this.queryData.hasNext();
    }

    public SimpleFeature next() throws IllegalAttributeException, IOException {
        if (this.queryData.isClosed()) {
            throw new IOException("The feature reader has been closed");
        }
        return this.readFeature();
    }

    private SimpleFeature readFeature() throws IllegalAttributeException, IOException {
        this.queryData.next();
        for (int i = 0; i < this.fidAttributes.length; ++i) {
            this.fidAttributes[i] = this.queryData.readFidColumn(i);
        }
        FIDMapper mapper = this.queryData.getMapper();
        String fid = mapper.getID(this.fidAttributes);
        int attributeCount = this.queryData.getFeatureType().getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Object attribute = this.queryData.read(i);
            if (attribute instanceof Geometry && this.queryData.getFeatureType().getDescriptor(i) instanceof GeometryDescriptor) {
                Geometry geometry = (Geometry)attribute;
                GeometryDescriptor geometryType = (GeometryDescriptor)this.queryData.getFeatureType().getDescriptor(i);
                if (geometryType.getCoordinateReferenceSystem() != null) {
                    geometry.setUserData((Object)geometryType.getCoordinateReferenceSystem());
                }
            }
            this.builder.add(attribute);
        }
        return this.builder.buildFeature(fid);
    }

    public SimpleFeatureType getFeatureType() {
        return this.queryData.getFeatureType();
    }
}

