/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.Converters;

public abstract class PreparedStatementSQLDialect
extends SQLDialect {
    protected PreparedStatementSQLDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void prepareGeometryValue(Geometry g, int srid, Class binding, StringBuffer sql) {
        sql.append("?");
    }

    public void prepareFunctionArgument(Class clazz, StringBuffer sql) {
        sql.append("?");
    }

    public abstract void setGeometryValue(Geometry var1, int var2, Class var3, PreparedStatement var4, int var5) throws SQLException;

    public void setValue(Object value, Class binding, PreparedStatement ps, int column, Connection cx) throws SQLException {
        Integer sqlType = this.dataStore.getMapping(binding);
        if (value == null) {
            ps.setNull(column, sqlType);
            return;
        }
        if (!binding.isInstance(value)) {
            Object converted = Converters.convert((Object)value, (Class)binding);
            if (converted != null) {
                value = converted;
            } else {
                this.dataStore.getLogger().warning("Unable to convert " + value + " to " + binding.getName());
            }
        }
        switch (sqlType) {
            case 12: {
                ps.setString(column, (String)value);
                break;
            }
            case 16: {
                ps.setBoolean(column, (Boolean)value);
                break;
            }
            case 5: {
                ps.setShort(column, (Short)value);
                break;
            }
            case 4: {
                ps.setInt(column, (Integer)value);
                break;
            }
            case -5: {
                ps.setLong(column, (Long)value);
                break;
            }
            case 7: {
                ps.setFloat(column, ((Float)value).floatValue());
                break;
            }
            case 8: {
                ps.setDouble(column, (Double)value);
                break;
            }
            case 2: {
                ps.setBigDecimal(column, (BigDecimal)value);
                break;
            }
            case 91: {
                ps.setDate(column, (Date)value);
                break;
            }
            case 92: {
                ps.setTime(column, (Time)value);
                break;
            }
            case 93: {
                ps.setTimestamp(column, (Timestamp)value);
                break;
            }
            default: {
                ps.setObject(column, value);
            }
        }
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        PreparedFilterToSQL f2s = new PreparedFilterToSQL();
        f2s.setCapabilities(BASE_DBMS_CAPABILITIES);
        return f2s;
    }
}

