/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.util.Collections;
import java.util.HashSet;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.GeoAPISQLBuilder;
import org.geotools.data.jdbc.SQLFilterTestSupport;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;

public class GeoApiSqlBuilderTest
extends SQLFilterTestSupport {
    GeoAPISQLBuilder builder;
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public GeoApiSqlBuilderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        FilterToSQL filterToSQL = new FilterToSQL();
        filterToSQL.setSqlNameEscape("\"");
        this.builder = new GeoAPISQLBuilder(filterToSQL, testSchema, null);
    }

    public void testExpression() throws Exception {
        Add a = this.ff.add((Expression)this.ff.property("testInteger"), (Expression)this.ff.literal(5));
        StringBuffer sb = new StringBuffer();
        this.builder.encode(sb, (Expression)a);
        GeoApiSqlBuilderTest.assertEquals((String)"\"testInteger\" + 5", (String)sb.toString());
    }

    public void testFilter() throws Exception {
        PropertyIsEqualTo equal = this.ff.equal((Expression)this.ff.property("testInteger"), (Expression)this.ff.literal(5), false);
        StringBuffer sb = new StringBuffer();
        this.builder.encode(sb, (Filter)equal);
        GeoApiSqlBuilderTest.assertEquals((String)"\"testInteger\" = 5", (String)sb.toString());
    }

    public void testGetPrePostQueryFilterWithFidValidation() throws Exception {
        String featureTypeName = "FT.Name";
        TypedFIDMapper mapper = new TypedFIDMapper((FIDMapper)new BasicFIDMapper("id", 5), "FT.Name");
        FilterToSQL filterToSQL = new FilterToSQL();
        filterToSQL.setFIDMapper((FIDMapper)mapper);
        filterToSQL.setSqlNameEscape("\"");
        this.builder = new GeoAPISQLBuilder(filterToSQL, testSchema, null);
        HashSet<Object> ids = new HashSet<Object>();
        ids.add(this.ff.featureId("discarded.1"));
        ids.add(this.ff.gmlObjectId("discarded.2"));
        FeatureId validFid = this.ff.featureId("FT.Name.fid-something");
        ids.add(validFid);
        Id id = this.ff.id(ids);
        Filter preFilter = this.builder.getPreQueryFilter((Filter)id);
        Filter postFilter = this.builder.getPostQueryFilter((Filter)id);
        Id expected = this.ff.id(Collections.singleton(validFid));
        GeoApiSqlBuilderTest.assertEquals((Object)expected, (Object)preFilter);
        GeoApiSqlBuilderTest.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
    }
}

