/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BetweenFilterImpl;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.SQLFilterTestSupport;
import org.geotools.filter.SQLUnpacker;
import org.geotools.filter.expression.AddImpl;

public class SQLUnpackerTest
extends SQLFilterTestSupport {
    private BetweenFilterImpl btwnFilter;
    private CompareFilter compFilter;
    private GeometryFilter geomFilter;
    private LikeFilterImpl likeFilter;
    private NullFilterImpl nullFilter;
    private AttributeExpressionImpl attrExp1;
    private AttributeExpressionImpl attrExp2;
    private LiteralExpressionImpl litExp1;
    private LiteralExpressionImpl litExp2;
    private MathExpressionImpl mathExp1;
    private String pattern = "te_st!";
    private String wcMulti = "!";
    private String wcSingle = "_";
    private String escape = "#";
    private FilterCapabilities capabilities;
    private SQLUnpacker unpacker;
    TestSuite suite = null;

    public SQLUnpackerTest(String testName) {
        super(testName);
        LOGGER.finer("running SQLUnpackerTests");
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SQLUnpackerTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SQLUnpackerTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException, IllegalAttributeException {
        super.setUp();
        this.setup = true;
        this.capabilities = new FilterCapabilities();
        this.capabilities.addType((short)1);
        this.capabilities.addType((short)2);
        this.capabilities.addType((short)3);
        this.capabilities.addType((short)14);
        this.capabilities.addType((short)15);
        this.capabilities.addType((short)16);
        this.capabilities.addType((short)17);
        this.capabilities.addType((short)18);
        this.capabilities.addType((short)21);
        this.capabilities.addType((short)19);
        this.unpacker = new SQLUnpacker(this.capabilities);
        try {
            this.attrExp1 = new AttributeExpressionImpl(testSchema, "testInteger");
            this.attrExp2 = new AttributeExpressionImpl(testSchema, "testGeometry");
            this.litExp1 = new LiteralExpressionImpl((Object)new Integer(65));
            this.litExp2 = new LiteralExpressionImpl((Object)new Integer(35));
            this.mathExp1 = new AddImpl(null, null);
            this.mathExp1.addLeftValue((Expression)this.litExp1);
            this.mathExp1.addRightValue((Expression)this.litExp2);
            this.btwnFilter = new BetweenFilterImpl();
            this.btwnFilter.addLeftValue((Expression)this.litExp1);
            this.btwnFilter.addMiddleValue((Expression)this.attrExp1);
            this.btwnFilter.addRightValue((Expression)this.mathExp1);
            FilterFactory factory = FilterFactoryFinder.createFilterFactory();
            this.compFilter = factory.createCompareFilter((short)15);
            this.compFilter.addLeftValue((Expression)this.attrExp1);
            this.compFilter.addRightValue((Expression)this.litExp2);
            this.geomFilter = factory.createGeometryFilter((short)8);
            this.geomFilter.addLeftGeometry((Expression)this.attrExp2);
            this.geomFilter.addRightGeometry((Expression)this.litExp2);
            this.likeFilter = new LikeFilterImpl();
            this.likeFilter.setValue((Expression)this.attrExp1);
            this.likeFilter.setPattern(this.pattern, this.wcMulti, this.wcSingle, this.escape);
            this.nullFilter = new NullFilterImpl();
            this.nullFilter.nullCheckValue((Expression)this.attrExp2);
        }
        catch (IllegalFilterException e) {
            SQLUnpackerTest.fail((String)e.getMessage());
        }
        LOGGER.finer("...set up complete");
    }

    public void testBasics() throws IllegalFilterException {
        this.unpacker.unPackAND((org.opengis.filter.Filter)this.btwnFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.btwnFilter, (Object)this.unpacker.getSupported());
        this.unpacker.unPackAND((org.opengis.filter.Filter)this.compFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.compFilter, (Object)this.unpacker.getSupported());
        this.unpacker.unPackAND((org.opengis.filter.Filter)this.geomFilter);
        SQLUnpackerTest.assertEquals((Object)this.geomFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        this.unpacker.unPackAND((org.opengis.filter.Filter)this.likeFilter);
        SQLUnpackerTest.assertEquals((Object)this.likeFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        this.unpacker.unPackAND((org.opengis.filter.Filter)this.nullFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.nullFilter, (Object)this.unpacker.getSupported());
    }

    public void testBasicsOR() throws IllegalFilterException {
        this.unpacker.unPackOR((org.opengis.filter.Filter)this.btwnFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.btwnFilter, (Object)this.unpacker.getSupported());
        this.unpacker.unPackOR((org.opengis.filter.Filter)this.compFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.compFilter, (Object)this.unpacker.getSupported());
        this.unpacker.unPackOR((org.opengis.filter.Filter)this.geomFilter);
        SQLUnpackerTest.assertEquals((Object)this.geomFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        this.unpacker.unPackOR((org.opengis.filter.Filter)this.likeFilter);
        SQLUnpackerTest.assertEquals((Object)this.likeFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        this.unpacker.unPackOR((org.opengis.filter.Filter)this.nullFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.nullFilter, (Object)this.unpacker.getSupported());
    }

    public void testAnd() throws IllegalFilterException {
        Filter andFilter = this.btwnFilter.and((org.opengis.filter.Filter)this.compFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)andFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)andFilter, (Object)this.unpacker.getSupported());
        andFilter = this.likeFilter.and((org.opengis.filter.Filter)this.compFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)andFilter);
        SQLUnpackerTest.assertEquals((Object)this.likeFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.compFilter, (Object)this.unpacker.getSupported());
        andFilter = this.likeFilter.and((org.opengis.filter.Filter)this.geomFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)andFilter);
        SQLUnpackerTest.assertEquals((Object)andFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
    }

    public void testNot() throws IllegalFilterException {
        Filter notFilter = this.nullFilter.not();
        this.unpacker.unPackAND((org.opengis.filter.Filter)notFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)notFilter, (Object)this.unpacker.getSupported());
        notFilter = this.geomFilter.not();
        this.unpacker.unPackAND((org.opengis.filter.Filter)notFilter);
        SQLUnpackerTest.assertEquals((Object)notFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
    }

    public void testOr() throws IllegalFilterException {
        Filter orFilter = this.btwnFilter.or((org.opengis.filter.Filter)this.compFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)orFilter);
        SQLUnpackerTest.assertNull((Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)orFilter, (Object)this.unpacker.getSupported());
        orFilter = this.likeFilter.or((org.opengis.filter.Filter)this.compFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)orFilter);
        SQLUnpackerTest.assertEquals((Object)orFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        orFilter = this.likeFilter.and((org.opengis.filter.Filter)this.geomFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)orFilter);
        SQLUnpackerTest.assertEquals((Object)orFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
    }

    public void testComplex() throws IllegalFilterException {
        Filter orFilter = this.likeFilter.or((org.opengis.filter.Filter)this.btwnFilter);
        Filter andFilter = orFilter.and((org.opengis.filter.Filter)this.compFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)andFilter);
        SQLUnpackerTest.assertEquals((Object)orFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.compFilter, (Object)this.unpacker.getSupported());
        Filter bigOrFilter = andFilter.or((org.opengis.filter.Filter)this.compFilter).or((org.opengis.filter.Filter)this.nullFilter);
        Filter biggerOrFilter = bigOrFilter.or((org.opengis.filter.Filter)this.nullFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)biggerOrFilter);
        SQLUnpackerTest.assertEquals((Object)biggerOrFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        Filter bigAndFilter = this.geomFilter.and((org.opengis.filter.Filter)this.compFilter).and((org.opengis.filter.Filter)orFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)bigAndFilter);
        SQLUnpackerTest.assertEquals((Object)orFilter.and((org.opengis.filter.Filter)this.geomFilter), (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertEquals((Object)this.compFilter, (Object)this.unpacker.getSupported());
        this.unpacker.unPackOR((org.opengis.filter.Filter)bigAndFilter);
        SQLUnpackerTest.assertEquals((Object)bigAndFilter, (Object)this.unpacker.getUnSupported());
        SQLUnpackerTest.assertNull((Object)this.unpacker.getSupported());
        Filter hugeAndFilter = bigAndFilter.and((org.opengis.filter.Filter)andFilter).and((org.opengis.filter.Filter)bigOrFilter);
        this.unpacker.unPackAND((org.opengis.filter.Filter)hugeAndFilter);
        SQLUnpackerTest.assertEquals((Object)this.compFilter.and((org.opengis.filter.Filter)this.compFilter), (Object)this.unpacker.getSupported());
        Filter expected = this.geomFilter.and((org.opengis.filter.Filter)orFilter).and((org.opengis.filter.Filter)orFilter).and((org.opengis.filter.Filter)bigOrFilter);
        org.opengis.filter.Filter unsupported = this.unpacker.getUnSupported();
        SQLUnpackerTest.assertEquals((Object)expected, (Object)unsupported);
    }
}

