/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.QuantileListVisitor;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class QuantileFunction
extends ClassificationFunction {
    public QuantileFunction() {
        this.setName("Quantile");
    }

    public int getArgCount() {
        return 2;
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        QuantileListVisitor quantileVisit = new QuantileListVisitor((Expression)this.getExpression(), this.getClasses());
        if (this.progress == null) {
            this.progress = new NullProgressListener();
        }
        try {
            featureCollection.accepts((FeatureVisitor)quantileVisit, (ProgressListener)this.progress);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "QuantileFunction calculate(SimpleFeatureCollection) failed", e);
            return null;
        }
        if (this.progress.isCanceled()) {
            return null;
        }
        CalcResult calcResult = quantileVisit.getResult();
        if (calcResult == null) {
            return null;
        }
        List[] bin = (List[])calcResult.getValue();
        Comparable globalMin = (Comparable)bin[0].toArray()[0];
        Object[] lastBin = bin[bin.length - 1].toArray();
        if (lastBin.length == 0) {
            return null;
        }
        Comparable globalMax = (Comparable)lastBin[lastBin.length - 1];
        if (globalMin instanceof Number && globalMax instanceof Number) {
            return this.calculateNumerical(bin, globalMin, globalMax);
        }
        return this.calculateNonNumerical(bin);
    }

    private Object calculateNumerical(List[] bin, Comparable globalMin, Comparable globalMax) {
        int classNum = bin.length;
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        for (int i = 0; i < classNum; ++i) {
            List thisBin = bin[i];
            localMin[i] = (Comparable)thisBin.get(0);
            localMax[i] = (Comparable)thisBin.get(thisBin.size() - 1);
            double slotWidth = ((Number)((Object)localMax[i])).doubleValue() - ((Number)((Object)localMin[i])).doubleValue();
            if (slotWidth == 0.0) {
                slotWidth = (((Number)((Object)globalMax)).doubleValue() - ((Number)((Object)globalMin)).doubleValue()) / (double)classNum;
            }
            int decPlaces = this.decimalPlaces(slotWidth);
            decPlaces = Math.max(decPlaces, this.decimalPlaces(((Number)((Object)localMin[i])).doubleValue()));
            if ((decPlaces = Math.max(decPlaces, this.decimalPlaces(((Number)((Object)localMax[i])).doubleValue()))) > -1) {
                localMin[i] = new Double(this.round(((Number)((Object)localMin[i])).doubleValue(), decPlaces));
                localMax[i] = new Double(this.round(((Number)((Object)localMax[i])).doubleValue(), decPlaces));
            }
            if (i == 0) {
                if (localMin[i].compareTo(new Double(((Number)((Object)globalMin)).doubleValue())) > 0) {
                    localMin[i] = new Double(this.fixRound(((Number)((Object)localMin[i])).doubleValue(), decPlaces, false));
                }
            } else if (i == classNum - 1 && localMax[i].compareTo(new Double(((Number)((Object)globalMax)).doubleValue())) < 0) {
                localMax[i] = new Double(this.fixRound(((Number)((Object)localMax[i])).doubleValue(), decPlaces, true));
            }
            if (i == 0) continue;
            localMax[i - 1] = localMin[i];
        }
        return new RangedClassifier(localMin, localMax);
    }

    private Object calculateNonNumerical(List[] bin) {
        int classNum = bin.length;
        Set[] values = new Set[classNum];
        for (int i = 0; i < classNum; ++i) {
            values[i] = new HashSet();
            Iterator iterator = bin[i].iterator();
            while (iterator.hasNext()) {
                values[i].add(iterator.next());
            }
        }
        return new ExplicitClassifier(values);
    }

    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }
}

