/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewTest
extends TestCase {
    String typeName = "type1";
    private MemoryDataStore ds;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureType ft = DataUtilities.createType((String)this.typeName, (String)"geom:Point,name:String,id:int");
        this.ds = new MemoryDataStore();
        this.ds.addFeature(this.createFeatures(ft, 1));
        this.ds.addFeature(this.createFeatures(ft, 2));
        this.ds.addFeature(this.createFeatures(ft, 3));
        this.ds.addFeature(this.createFeatures(ft, 4));
    }

    private SimpleFeature createFeatures(SimpleFeatureType ft, int i) throws IllegalAttributeException {
        GeometryFactory fac = new GeometryFactory();
        return SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{fac.createPoint(new Coordinate((double)i, (double)i)), "name" + i, new Integer(i)}, null);
    }

    public void testGetFeatures() throws Exception {
        FeatureSource<SimpleFeatureType, SimpleFeature> view = this.getView();
        FeatureIterator features = view.getFeatures().features();
        int count = 0;
        while (features.hasNext()) {
            ++count;
            features.next();
        }
        DefaultViewTest.assertEquals((int)2, (int)count);
    }

    public void testGetFeaturesQuery() throws Exception {
        FeatureSource<SimpleFeatureType, SimpleFeature> view = this.getView();
        FeatureIterator features = view.getFeatures((Query)this.getQuery()).features();
        int count = 0;
        while (features.hasNext()) {
            ++count;
            features.next();
        }
        DefaultViewTest.assertEquals((int)1, (int)count);
    }

    public void testGetFeaturesFilter() throws Exception {
        FeatureSource<SimpleFeatureType, SimpleFeature> view = this.getView();
        Filter f = this.getFilter();
        FeatureIterator features = view.getFeatures(f).features();
        int count = 0;
        while (features.hasNext()) {
            ++count;
            features.next();
        }
        DefaultViewTest.assertEquals((int)1, (int)count);
    }

    public void testGetCount() throws Exception {
        FeatureSource<SimpleFeatureType, SimpleFeature> view = this.getView();
        DefaultQuery defaultQuery = this.getQuery();
        int count = view.getCount((Query)defaultQuery);
        DefaultViewTest.assertEquals((int)1, (int)count);
    }

    private DefaultQuery getQuery() throws IllegalFilterException {
        Filter f = this.getFilter();
        DefaultQuery defaultQuery = new DefaultQuery(this.typeName, f, new String[0]);
        return defaultQuery;
    }

    private Filter getFilter() throws IllegalFilterException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = fac.equals((Expression)fac.property("name"), (Expression)fac.literal((Object)"name2"));
        return f;
    }

    private FeatureSource<SimpleFeatureType, SimpleFeature> getView() throws IllegalFilterException, IOException, SchemaException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsLessThan f = fac.less((Expression)fac.property("id"), (Expression)fac.literal(3));
        FeatureSource view = this.ds.getView((Query)new DefaultQuery(this.typeName, (Filter)f));
        return view;
    }
}

