/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.geotools.feature.type.DateUtil;

public class DateUtilTest
extends TestCase {
    public void testJavaUtilDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 3, 1, 1, 15);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2007-04-01T01:15:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2007-04-01", (String)date);
    }

    public void testSqlDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 3, 1, 1, 15);
        Date time = cal.getTime();
        java.sql.Date date = new java.sql.Date(time.getTime());
        String dateTime = DateUtil.serializeSqlDate((java.sql.Date)date);
        DateUtilTest.assertEquals((String)"2007-04-01", (String)dateTime);
    }

    public void testSqlTime() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 3, 1, 1, 15);
        long lngTime = cal.getTime().getTime();
        Time time = new Time(lngTime);
        System.out.println(time);
        String t = DateUtil.serializeSqlTime((Time)time);
        System.out.println(t);
        DateUtilTest.assertEquals((String)"01:15:00", (String)t);
    }
}

