/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.QuantileListVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class VisitorCalculationTest
extends DataTestCase {
    FeatureCollection<SimpleFeatureType, SimpleFeature> fc;
    SimpleFeatureType ft;
    FeatureCollection<SimpleFeatureType, SimpleFeature> fc2;
    SimpleFeatureType ft2;
    FeatureCollection<SimpleFeatureType, SimpleFeature> fc3;
    SimpleFeatureType ft3;

    public VisitorCalculationTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fc = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        this.fc2 = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.ft = this.roadType;
        this.ft2 = this.riverType;
        SimpleFeatureType boringType = DataUtilities.createType((String)"fc3.boring", (String)"id:0");
        SimpleFeature[] boringFeatures = new SimpleFeature[100];
        for (int i = 1; i <= 100; ++i) {
            boringFeatures[i - 1] = SimpleFeatureBuilder.build((SimpleFeatureType)boringType, (Object[])new Object[]{new Integer(i)}, null);
        }
        this.ft3 = boringType;
        this.fc3 = DataUtilities.collection((SimpleFeature[])boringFeatures);
    }

    public void testMin() throws IllegalFilterException, IOException {
        MinVisitor minVisitor = new MinVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)minVisitor, null);
        MinVisitor minVisitor2 = new MinVisitor(0, this.ft2);
        this.fc2.accepts((FeatureVisitor)minVisitor2, null);
        Object result = minVisitor.getResult().getValue();
        int value = (Integer)result;
        VisitorCalculationTest.assertEquals((int)1, (int)value);
        int value2 = minVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)1, (int)value2);
        CalcResult minResult1 = minVisitor.getResult();
        CalcResult minResult2 = minVisitor2.getResult();
        CalcResult minResult3 = minResult1.merge(minResult2);
        VisitorCalculationTest.assertEquals((int)1, (int)minResult3.toInt());
        MinVisitor.MinResult minResult4 = new MinVisitor.MinResult((Comparable)new Integer(10));
        CalcResult minResult5 = minResult4.merge(minResult1);
        VisitorCalculationTest.assertEquals((int)1, (int)minResult5.toInt());
        VisitorCalculationTest.assertEquals((int)10, (int)minResult4.toInt());
        MinVisitor.MinResult minResult6 = new MinVisitor.MinResult((Comparable)new Integer(-5));
        MinVisitor.MinResult minResult7 = (MinVisitor.MinResult)minResult1.merge((CalcResult)minResult6);
        VisitorCalculationTest.assertEquals((int)-5, (int)minResult7.toInt());
        VisitorCalculationTest.assertEquals((int)-5, (int)minResult6.toInt());
        minVisitor.setValue((Object)new Integer(-50));
        minResult1 = minVisitor.getResult();
        minResult7 = minResult7.merge(minResult1);
        VisitorCalculationTest.assertEquals((int)-50, (int)minResult7.toInt());
        minVisitor.setValue((Object)new Double(-100.0));
        minResult1 = minVisitor.getResult();
        minResult7 = minResult7.merge(minResult1);
        VisitorCalculationTest.assertEquals((double)-100.0, (double)minResult7.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((int)-100, (int)minResult7.toInt());
    }

    public void testMax() throws IllegalFilterException, IOException {
        MaxVisitor maxVisitor = new MaxVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)maxVisitor, null);
        MaxVisitor maxVisitor2 = new MaxVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)maxVisitor2, null);
        int value1 = maxVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)3, (int)value1);
        double value2 = maxVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((double)4.5, (double)value2, (double)0.0);
        MaxVisitor.MaxResult maxResult1 = (MaxVisitor.MaxResult)maxVisitor.getResult();
        MaxVisitor.MaxResult maxResult2 = (MaxVisitor.MaxResult)maxVisitor2.getResult();
        MaxVisitor.MaxResult maxResult3 = (MaxVisitor.MaxResult)maxResult1.merge((CalcResult)maxResult2);
        VisitorCalculationTest.assertEquals((double)4.5, (double)maxResult3.toDouble(), (double)0.0);
        MaxVisitor.MaxResult maxResult4 = new MaxVisitor.MaxResult((Comparable)new Double(2.0));
        MaxVisitor.MaxResult maxResult5 = (MaxVisitor.MaxResult)maxResult4.merge((CalcResult)maxResult1);
        VisitorCalculationTest.assertEquals((double)3.0, (double)maxResult5.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)2.0, (double)maxResult4.toDouble(), (double)0.0);
        MaxVisitor.MaxResult maxResult6 = new MaxVisitor.MaxResult((Comparable)new Integer(-5));
        MaxVisitor.MaxResult maxResult7 = (MaxVisitor.MaxResult)maxResult1.merge((CalcResult)maxResult6);
        VisitorCalculationTest.assertEquals((double)3.0, (double)maxResult7.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)-5.0, (double)maxResult6.toDouble(), (double)0.0);
        maxVisitor.setValue((Object)new Double(544.0));
        maxResult1 = maxVisitor.getResult();
        maxResult7 = maxResult7.merge((CalcResult)maxResult1);
        VisitorCalculationTest.assertEquals((double)544.0, (double)maxResult7.toDouble(), (double)0.0);
        maxVisitor.setValue((Object)new Long(6453L));
        maxResult1 = maxVisitor.getResult();
        maxResult7 = maxResult7.merge((CalcResult)maxResult1);
        VisitorCalculationTest.assertEquals((double)6453.0, (double)maxResult7.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((int)6453, (int)maxResult7.toInt());
    }

    public void testMedian() throws IllegalFilterException, IOException {
        MedianVisitor medianVisitor1 = new MedianVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)medianVisitor1, null);
        MedianVisitor medianVisitor2 = new MedianVisitor(0, this.ft2);
        this.fc2.accepts((FeatureVisitor)medianVisitor2, null);
        CalcResult medianResult1 = medianVisitor1.getResult();
        CalcResult medianResult2 = medianVisitor2.getResult();
        VisitorCalculationTest.assertEquals((int)2, (int)medianResult1.toInt());
        VisitorCalculationTest.assertEquals((double)1.5, (double)medianResult2.toDouble(), (double)0.0);
        CalcResult medianResult3 = medianResult1.merge(medianResult2);
        VisitorCalculationTest.assertEquals((double)2.0, (double)medianResult3.toDouble(), (double)0.0);
        ArrayList<Double> vals = new ArrayList<Double>();
        vals.add(new Double(2.5));
        vals.add(new Double(3.5));
        vals.add(new Double(4.5));
        MedianVisitor.MedianResult medianResult4 = new MedianVisitor.MedianResult(vals);
        CalcResult medianResult5 = medianResult4.merge(medianResult1);
        VisitorCalculationTest.assertEquals((double)2.75, (double)medianResult5.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)3.5, (double)medianResult4.toDouble(), (double)0.0);
        medianVisitor1.setValue((Comparable)new Double(544.0));
        medianResult1 = medianVisitor1.getResult();
        try {
            medianResult3 = medianResult5.merge(medianResult1);
            VisitorCalculationTest.fail();
        }
        catch (Exception e) {
            VisitorCalculationTest.assertEquals((String)"Optimized median results cannot be merged.", (String)e.getMessage());
        }
    }

    public void testSum() throws IllegalFilterException, IOException {
        SumVisitor sumVisitor = new SumVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)sumVisitor, null);
        SumVisitor sumVisitor2 = new SumVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)sumVisitor2, null);
        int value1 = sumVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)6, (int)value1);
        double value2 = sumVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((double)7.5, (double)value2, (double)0.0);
        CalcResult sumResult1 = sumVisitor.getResult();
        CalcResult sumResult2 = sumVisitor2.getResult();
        CalcResult sumResult3 = sumResult1.merge(sumResult2);
        VisitorCalculationTest.assertEquals((double)13.5, (double)sumResult3.toDouble(), (double)0.0);
        sumVisitor2.setValue((Object)new Integer(-42));
        CalcResult sumResult4 = sumVisitor2.getResult();
        CalcResult sumResult5 = sumResult3.merge(sumResult4);
        VisitorCalculationTest.assertEquals((double)-28.5, (double)sumResult5.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)13.5, (double)sumResult3.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)-42.0, (double)sumResult4.toDouble(), (double)0.0);
    }

    public void testCount() throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        this.fc.accepts((FeatureVisitor)countVisitor, null);
        CountVisitor countVisitor2 = new CountVisitor();
        this.fc2.accepts((FeatureVisitor)countVisitor2, null);
        int value1 = countVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)3, (int)value1);
        int value2 = countVisitor2.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)2, (int)value2);
        CalcResult countResult1 = countVisitor.getResult();
        CalcResult countResult2 = countVisitor2.getResult();
        CalcResult countResult3 = countResult1.merge(countResult2);
        VisitorCalculationTest.assertEquals((int)5, (int)countResult3.toInt());
        countVisitor.setValue(20);
        CalcResult countResult4 = countVisitor.getResult();
        VisitorCalculationTest.assertEquals((int)20, (int)countResult4.toInt());
        CalcResult countResult5 = countResult4.merge(countResult3);
        VisitorCalculationTest.assertEquals((int)5, (int)countResult3.toInt());
        VisitorCalculationTest.assertEquals((int)20, (int)countResult4.toInt());
        VisitorCalculationTest.assertEquals((int)25, (int)countResult5.toInt());
    }

    public void testAverage() throws IllegalFilterException, IOException {
        AverageVisitor averageVisitor = new AverageVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)averageVisitor, null);
        AverageVisitor averageVisitor2 = new AverageVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)averageVisitor2, null);
        int value1 = averageVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)2, (int)value1);
        double value2 = averageVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((double)3.75, (double)value2, (double)0.0);
        CalcResult averageResult1 = averageVisitor.getResult();
        CalcResult averageResult2 = averageVisitor2.getResult();
        CalcResult averageResult3 = averageResult1.merge(averageResult2);
        VisitorCalculationTest.assertEquals((double)2.7, (double)averageResult3.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)3.75, (double)averageResult2.toDouble(), (double)0.0);
        averageVisitor2.setValue(5, (Object)new Integer(100));
        averageResult2 = averageVisitor2.getResult();
        VisitorCalculationTest.assertEquals((int)20, (int)averageResult2.toInt());
        averageResult3 = averageResult1.merge(averageResult2);
        VisitorCalculationTest.assertEquals((double)13.25, (double)averageResult3.toDouble(), (double)0.0);
        averageVisitor2.setValue((Object)new Double(15.4));
        averageResult2 = averageVisitor2.getResult();
        VisitorCalculationTest.assertEquals((double)15.4, (double)averageResult2.toDouble(), (double)0.0);
        try {
            averageResult3 = averageResult1.merge(averageResult2);
            VisitorCalculationTest.fail();
        }
        catch (Exception e) {
            VisitorCalculationTest.assertEquals((String)"Optimized average results cannot be merged.", (String)e.getMessage());
        }
        averageVisitor.setValue(5, (Object)new Integer(10));
        averageResult1 = averageVisitor.getResult();
        averageVisitor2.setValue(5, (Object)new Double(33.3));
        averageResult2 = averageVisitor2.getResult();
        averageResult3 = averageResult1.merge(averageResult2);
        VisitorCalculationTest.assertEquals((double)4.33, (double)averageResult3.toDouble(), (double)0.0);
    }

    public void testUnique() throws IllegalFilterException, IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        UniqueVisitor uniqueVisitor2 = new UniqueVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)uniqueVisitor2, null);
        Set value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((int)3, (int)value1.size());
        Object[] value2 = uniqueVisitor2.getResult().toArray();
        VisitorCalculationTest.assertEquals((int)2, (int)value2.length);
        CalcResult uniqueResult1 = uniqueVisitor.getResult();
        CalcResult uniqueResult2 = uniqueVisitor2.getResult();
        CalcResult uniqueResult3 = uniqueResult1.merge(uniqueResult2);
        VisitorCalculationTest.assertEquals((int)5, (int)uniqueResult3.toSet().size());
        VisitorCalculationTest.assertEquals((int)3, (int)uniqueResult1.toSet().size());
        HashSet<Integer> anotherSet = new HashSet<Integer>();
        anotherSet.add(new Integer(2));
        anotherSet.add(new Integer(4));
        UniqueVisitor.UniqueResult uniqueResult4 = new UniqueVisitor.UniqueResult(anotherSet);
        CalcResult uniqueResult5 = uniqueResult1.merge((CalcResult)uniqueResult4);
        VisitorCalculationTest.assertEquals((int)4, (int)uniqueResult5.toSet().size());
        uniqueVisitor.setValue(anotherSet);
        uniqueResult1 = uniqueVisitor.getResult();
        VisitorCalculationTest.assertEquals(anotherSet, (Object)uniqueResult1.toSet());
        uniqueResult3 = uniqueResult2.merge(uniqueResult1);
        Set set = uniqueResult3.toSet();
        VisitorCalculationTest.assertTrue((set.size() == 4 ? 1 : 0) != 0);
        VisitorCalculationTest.assertTrue((boolean)set.contains(3.0));
        VisitorCalculationTest.assertTrue((boolean)set.contains(4.5));
        VisitorCalculationTest.assertTrue((boolean)set.contains(2));
        VisitorCalculationTest.assertTrue((boolean)set.contains(4));
        VisitorCalculationTest.assertFalse((boolean)set.contains(6));
    }

    public void testBounds() throws IOException {
        BoundsVisitor boundsVisitor1 = new BoundsVisitor();
        this.fc.accepts((FeatureVisitor)boundsVisitor1, null);
        BoundsVisitor boundsVisitor2 = new BoundsVisitor();
        this.fc2.accepts((FeatureVisitor)boundsVisitor2, null);
        Envelope env1 = new Envelope(1.0, 5.0, 0.0, 4.0);
        CalcResult boundsResult1 = boundsVisitor1.getResult();
        VisitorCalculationTest.assertEquals((Object)env1, (Object)boundsResult1.toEnvelope());
        Envelope env2 = new Envelope(4.0, 13.0, 3.0, 10.0);
        CalcResult boundsResult2 = boundsVisitor2.getResult();
        VisitorCalculationTest.assertEquals((Object)env2, (Object)boundsResult2.toEnvelope());
        CalcResult boundsResult3 = boundsResult2.merge(boundsResult1);
        Envelope env3 = new Envelope(1.0, 13.0, 0.0, 10.0);
        VisitorCalculationTest.assertEquals((Object)env3, (Object)boundsResult3.toEnvelope());
    }

    public void testQuantileList() throws Exception {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyName expr = factory.property(this.ft.getDescriptor(0).getLocalName());
        QuantileListVisitor visitor = new QuantileListVisitor((Expression)expr, 2);
        this.fc.accepts((FeatureVisitor)visitor, null);
        List[] qResult = (List[])visitor.getResult().getValue();
        VisitorCalculationTest.assertEquals((int)2, (int)qResult.length);
        VisitorCalculationTest.assertEquals((int)2, (int)qResult[0].size());
        VisitorCalculationTest.assertEquals((int)1, (int)qResult[1].size());
    }

    public void testStandardDeviation() throws Exception {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyName expr = factory.property(this.ft3.getDescriptor(0).getLocalName());
        AverageVisitor visit1 = new AverageVisitor((Expression)expr);
        this.fc3.accepts((FeatureVisitor)visit1, null);
        double average = visit1.getResult().toDouble();
        System.out.println("AV=" + average);
        StandardDeviationVisitor visit2 = new StandardDeviationVisitor((Expression)expr, average);
        this.fc3.accepts((FeatureVisitor)visit2, null);
        VisitorCalculationTest.assertEquals((double)28.86, (double)visit2.getResult().toDouble(), (double)0.01);
    }

    public void testCountSumMerge() throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        this.fc2.accepts((FeatureVisitor)countVisitor, null);
        SumVisitor sumVisitor = new SumVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)sumVisitor, null);
        CalcResult countResult = countVisitor.getResult();
        CalcResult sumResult = sumVisitor.getResult();
        CalcResult averageResult1 = countResult.merge(sumResult);
        CalcResult averageResult2 = sumResult.merge(countResult);
        VisitorCalculationTest.assertEquals((double)3.75, (double)averageResult1.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)3.75, (double)averageResult2.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((int)2, (int)countResult.toInt());
        VisitorCalculationTest.assertEquals((double)7.5, (double)sumResult.toDouble(), (double)0.0);
    }

    public void testBadMerge() throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        countVisitor.setValue(8);
        CalcResult countResult = countVisitor.getResult();
        MaxVisitor maxVisitor = new MaxVisitor((Expression)null);
        maxVisitor.setValue((Object)new Double(99.0));
        CalcResult maxResult = maxVisitor.getResult();
        try {
            CalcResult boomResult = maxResult.merge(countResult);
            VisitorCalculationTest.fail();
        }
        catch (Exception e) {
            VisitorCalculationTest.assertEquals((String)"Parameter is not a compatible type", (String)e.getMessage());
        }
    }
}

