/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BetweenFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class BetweenTest
extends TestCase {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");

    public BetweenTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BetweenTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BetweenTest.class);
        return suite;
    }

    public void testContains() throws Exception {
        BetweenFilterImpl a = new BetweenFilterImpl();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("value", Integer.class);
        ftb.add("geometry", Geometry.class);
        ftb.setName("testSchema");
        SimpleFeatureType schema = ftb.buildFeatureType();
        a.addLeftValue((Expression)new LiteralExpressionImpl((Object)new Double(5.0)));
        a.addRightValue((Expression)new LiteralExpressionImpl((Object)new Double(15.0)));
        a.addMiddleValue((Expression)new AttributeExpressionImpl(schema, "value"));
        LOGGER.fine("geometry is " + schema.getDescriptor("geometry"));
        LOGGER.fine("value is " + schema.getDescriptor("value"));
        LOGGER.fine("schema has value in it ? " + (schema.getDescriptor("value") != null));
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(12), gf.createPoint(new Coordinate(12.0, 12.0))}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(3), gf.createPoint(new Coordinate(3.0, 3.0))}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(15), gf.createPoint(new Coordinate(15.0, 15.0))}, null);
        SimpleFeature f4 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(5), gf.createPoint(new Coordinate(5.0, 5.0))}, null);
        SimpleFeature f5 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{new Integer(30), gf.createPoint(new Coordinate(30.0, 30.0))}, null);
        BetweenTest.assertEquals((boolean)true, (boolean)a.contains(f1));
        BetweenTest.assertEquals((boolean)false, (boolean)a.contains(f2));
        BetweenTest.assertEquals((boolean)true, (boolean)a.contains(f3));
        BetweenTest.assertEquals((boolean)true, (boolean)a.contains(f4));
        BetweenTest.assertEquals((boolean)false, (boolean)a.contains(f5));
    }
}

