/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.RangedClassifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class EqualIntervalFunctionTest
extends FunctionTestSupport {
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public EqualIntervalFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EqualIntervalFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function equInt = ff.function("EqualInterval", new Expression[]{Expression.NIL});
        EqualIntervalFunctionTest.assertNotNull((Object)equInt);
        EqualIntervalFunctionTest.assertEquals((String)"test get name", (String)"EqualInterval", (String)equInt.getName());
    }

    public void testSetClasses() throws Exception {
        PropertyName property = ff.property("foo");
        Literal literal = ff.literal(3);
        EqualIntervalFunction func = (EqualIntervalFunction)ff.function("EqualInterval", new Expression[]{property, literal});
        EqualIntervalFunctionTest.assertEquals((int)3, (int)func.getClasses());
        func.getParameters().set(1, ff.literal(12));
        EqualIntervalFunctionTest.assertEquals((int)12, (int)func.getClasses());
    }

    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = ff.literal(3);
        PropertyName name = ff.property("foo");
        Function func = ff.function("EqualInterval", new Expression[]{name, classes});
        Object classifier = func.evaluate((Object)this.featureCollection);
        EqualIntervalFunctionTest.assertTrue((boolean)(classifier instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)classifier;
        EqualIntervalFunctionTest.assertEquals((int)3, (int)ranged.getSize());
        EqualIntervalFunctionTest.assertEquals((String)"4..32.667", (String)ranged.getTitle(0));
        EqualIntervalFunctionTest.assertEquals((String)"32.667..61.333", (String)ranged.getTitle(1));
        EqualIntervalFunctionTest.assertEquals((String)"61.333..90", (String)ranged.getTitle(2));
        EqualIntervalFunctionTest.assertEquals((int)0, (int)ranged.classify((Object)new Double(4.0)));
        EqualIntervalFunctionTest.assertEquals((int)2, (int)ranged.classify((Expression)name, (Object)this.testFeatures[1]));
        EqualIntervalFunctionTest.assertEquals((int)0, (int)ranged.classify((Object)new Double(20.0)));
        EqualIntervalFunctionTest.assertEquals((int)1, (int)ranged.classify((Object)new Double(43.0)));
        EqualIntervalFunctionTest.assertEquals((int)0, (int)ranged.classify((Object)new Double(29.0)));
        EqualIntervalFunctionTest.assertEquals((int)1, (int)ranged.classify((Object)new Double(61.0)));
        EqualIntervalFunctionTest.assertEquals((int)0, (int)ranged.classify((Expression)name, (Object)this.testFeatures[6]));
        EqualIntervalFunctionTest.assertEquals((int)0, (int)ranged.classify((Object)new Double(12.0)));
    }

    public void testEvaulateWithStrings() throws Exception {
        Function function = ff.function("EqualInterval", new Expression[]{ff.property("group"), ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)this.featureCollection);
        EqualIntervalFunctionTest.assertNotNull((Object)classifier);
        Classifier classifier2 = (Classifier)function.evaluate((Object)this.featureCollection, Classifier.class);
        EqualIntervalFunctionTest.assertNotNull((Object)classifier2);
        Integer number = (Integer)function.evaluate((Object)this.featureCollection, Integer.class);
        EqualIntervalFunctionTest.assertNull((Object)number);
    }

    public void testUpgradeExample() {
        Function function = ff.function("equalInterval", new Expression[]{ff.property("foo"), ff.literal(12)});
        Object value = function.evaluate((Object)this.featureCollection);
        EqualIntervalFunctionTest.assertNotNull((String)"classifier failed", (Object)value);
        Classifier split = (Classifier)value;
        Function classify = ff.function("classify", new Expression[]{ff.property("foo"), ff.literal((Object)split)});
        SimpleFeature victim = this.testFeatures[2];
        EqualIntervalFunctionTest.assertEquals((String)"Feature was placed in wrong bin", (Object)new Integer(2), (Object)classify.evaluate((Object)victim));
    }
}

