/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PropertyNameResolvingVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class PropertyNameResolvingFilterVisitorTest
extends TestCase {
    FilterFactory factory;
    SimpleFeatureType featureType;

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("test");
        b.add("name", String.class);
        this.featureType = b.buildFeatureType();
    }

    public void testResolvePropertyName() {
        PropertyIsEqualTo f = this.factory.equal((Expression)this.factory.property("gml:name"), (Expression)this.factory.literal((Object)"foo"), true);
        PropertyNameResolvingFilterVisitorTest.assertEquals((String)"gml:name", (String)f.getExpression1().toString());
        f = (PropertyIsEqualTo)f.accept((FilterVisitor)new PropertyNameResolvingVisitor(this.featureType), null);
        PropertyNameResolvingFilterVisitorTest.assertEquals((String)"name", (String)f.getExpression1().toString());
    }
}

