/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Geometry;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.Types;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class SimpleFeatureBuilder {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.feature");
    SimpleFeatureType featureType;
    FeatureFactory factory;
    Map<String, Integer> index;
    Object[] values;
    int next;
    Map<Object, Object>[] userData;
    boolean validating;

    public SimpleFeatureBuilder(SimpleFeatureType featureType) {
        this(featureType, CommonFactoryFinder.getFeatureFactory(null));
    }

    public SimpleFeatureBuilder(SimpleFeatureType featureType, FeatureFactory factory) {
        this.featureType = featureType;
        this.factory = factory;
        this.index = featureType instanceof SimpleFeatureTypeImpl ? ((SimpleFeatureTypeImpl)featureType).index : SimpleFeatureTypeImpl.buildIndex(featureType);
        this.reset();
    }

    public void reset() {
        this.values = new Object[this.featureType.getAttributeCount()];
        this.next = 0;
        this.userData = null;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void init(SimpleFeature feature) {
        this.reset();
        if (feature instanceof SimpleFeatureImpl) {
            SimpleFeatureImpl impl = (SimpleFeatureImpl)feature;
            System.arraycopy(impl.values, 0, this.values, 0, impl.values.length);
        } else {
            for (Object value : feature.getAttributes()) {
                this.add(value);
            }
        }
    }

    public void add(Object value) {
        this.set(this.next, value);
        ++this.next;
    }

    public void addAll(List values) {
        for (int i = 0; i < values.size(); ++i) {
            this.add(values.get(i));
        }
    }

    public void addAll(Object[] values) {
        this.addAll(Arrays.asList(values));
    }

    public void set(Name name, Object value) {
        this.set(name.getLocalPart(), value);
    }

    public void set(String name, Object value) {
        int index = this.featureType.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("No such attribute:" + name);
        }
        this.set(index, value);
    }

    public void set(int index, Object value) {
        if (index >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Can handle " + this.values.length + " attributes only, index is " + index);
        }
        AttributeDescriptor descriptor = this.featureType.getDescriptor(index);
        this.values[index] = this.convert(value, descriptor);
        if (this.validating) {
            Types.validate(descriptor, this.values[index]);
        }
    }

    private Object convert(Object value, AttributeDescriptor descriptor) {
        if (value != null) {
            Class target = descriptor.getType().getBinding();
            Object converted = Converters.convert(value, target);
            if (converted != null) {
                value = converted;
            }
        } else if (!descriptor.isNillable() && (value = descriptor.getDefaultValue()) == null) {
            value = DataUtilities.defaultValue(descriptor.getType().getBinding());
        }
        return value;
    }

    public SimpleFeature buildFeature(String id) {
        if (id == null) {
            id = SimpleFeatureBuilder.createDefaultFeatureId();
        }
        Object[] values = this.values;
        Map<Object, Object>[] userData = this.userData;
        this.reset();
        SimpleFeature sf = this.factory.createSimpleFeature(values, this.featureType, id);
        if (userData != null) {
            for (int i = 0; i < userData.length; ++i) {
                if (userData[i] == null) continue;
                sf.getProperty(this.featureType.getDescriptor(i).getName()).getUserData().putAll(userData[i]);
            }
        }
        return sf;
    }

    public SimpleFeature buildFeature(String id, Object[] values) {
        this.addAll(values);
        return this.buildFeature(id);
    }

    public static String createDefaultFeatureId() {
        return "fid-" + new UID().toString().replace(':', '_');
    }

    public static FeatureIdImpl createDefaultFeatureIdentifier(String suggestedId) {
        if (suggestedId != null) {
            return new FeatureIdImpl(suggestedId);
        }
        return new FeatureIdImpl(SimpleFeatureBuilder.createDefaultFeatureId());
    }

    public static SimpleFeature build(SimpleFeatureType type, Object[] values, String id) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.addAll(values);
        return builder.buildFeature(id);
    }

    public static SimpleFeature build(SimpleFeatureType type, List values, String id) {
        return SimpleFeatureBuilder.build(type, values.toArray(), id);
    }

    public static SimpleFeature copy(SimpleFeature original) {
        if (original == null) {
            return null;
        }
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(original.getFeatureType());
        builder.init(original);
        return builder.buildFeature(original.getID());
    }

    public static SimpleFeature deep(SimpleFeature original) {
        if (original == null) {
            return null;
        }
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(original.getFeatureType());
        try {
            for (Property property : original.getProperties()) {
                Object value;
                Object copy = value = property.getValue();
                if (value instanceof Geometry) {
                    Geometry geometry = (Geometry)value;
                    copy = geometry.clone();
                }
                builder.set(property.getName(), copy);
            }
            return builder.buildFeature(original.getID());
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException("illegal attribute").initCause((Throwable)e);
        }
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureId) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            builder.add(ad.getDefaultValue());
        }
        return builder.buildFeature(featureId);
    }

    public static SimpleFeature retype(SimpleFeature feature, SimpleFeatureType featureType) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            Object value = feature.getAttribute(att.getName());
            builder.set(att.getName(), value);
        }
        return builder.buildFeature(feature.getID());
    }

    public static SimpleFeature retype(SimpleFeature feature, SimpleFeatureBuilder builder) {
        builder.reset();
        for (AttributeDescriptor att : builder.getFeatureType().getAttributeDescriptors()) {
            Object value = feature.getAttribute(att.getName());
            builder.set(att.getName(), value);
        }
        return builder.buildFeature(feature.getID());
    }

    public SimpleFeatureBuilder userData(Object key, Object value) {
        return this.setUserData(this.next, key, value);
    }

    public SimpleFeatureBuilder setUserData(int index, Object key, Object value) {
        if (this.userData == null) {
            this.userData = new Map[this.values.length];
        }
        if (this.userData[index] == null) {
            this.userData[index] = new HashMap<Object, Object>();
        }
        this.userData[index].put(key, value);
        return this;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }
}

