/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSymbolizerImpl
implements PointSymbolizer,
Cloneable {
    private Description description;
    private String name;
    private Unit<Length> uom;
    private String geometryPropertyName = null;
    private GraphicImpl graphic = new GraphicImpl();

    protected PointSymbolizerImpl() {
        this(new GraphicImpl(), null, null, null, new DescriptionImpl((InternationalString)new SimpleInternationalString("title"), (InternationalString)new SimpleInternationalString("abstract")));
    }

    protected PointSymbolizerImpl(Graphic graphic, Unit<Length> uom, String geom, String name, Description desc) {
        this.graphic = GraphicImpl.cast((org.opengis.style.Graphic)graphic);
        this.uom = uom;
        this.geometryPropertyName = geom;
        this.name = name;
        this.description = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(org.opengis.style.Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public void setGeometryPropertyName(String name) {
        this.geometryPropertyName = name;
    }

    public Unit<Length> getUnitOfMeasure() {
        return this.uom;
    }

    public void setUnitOfMeasure(Unit<Length> uom) {
        this.uom = uom;
    }

    public GraphicImpl getGraphic() {
        return this.graphic;
    }

    public void setGraphic(org.opengis.style.Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = GraphicImpl.cast(graphic);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.PointSymbolizer)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((PointSymbolizer)this);
    }

    public Object clone() {
        PointSymbolizerImpl clone;
        try {
            clone = (PointSymbolizerImpl)super.clone();
            if (this.graphic != null) {
                clone.graphic = (GraphicImpl)this.graphic.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.graphic != null) {
            result = 1000003 * result + this.graphic.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.uom != null) {
            result = 1000003 * result + this.uom.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof PointSymbolizerImpl) {
            PointSymbolizerImpl other = (PointSymbolizerImpl)oth;
            return Utilities.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && Utilities.equals((Object)this.graphic, (Object)other.graphic) && Utilities.equals(this.uom, other.uom) && Utilities.equals((Object)this.description, (Object)other.description);
        }
        return false;
    }

    static PointSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof PointSymbolizerImpl) {
            return (PointSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.PointSymbolizer) {
            org.opengis.style.PointSymbolizer pointSymbolizer = (org.opengis.style.PointSymbolizer)symbolizer;
            PointSymbolizerImpl copy = new PointSymbolizerImpl();
            copy.setDescription(pointSymbolizer.getDescription());
            copy.setGeometryPropertyName(pointSymbolizer.getGeometryPropertyName());
            copy.setGraphic(pointSymbolizer.getGraphic());
            copy.setName(pointSymbolizer.getName());
            copy.setUnitOfMeasure((Unit<Length>)pointSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

