/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.TestReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class DiffWriterTest
extends TestCase {
    DiffFeatureWriter writer;
    private Point geom;
    private SimpleFeatureType type;

    protected void setUp() throws Exception {
        this.type = DataUtilities.createType((String)"default", (String)"name:String,*geom:Geometry");
        GeometryFactory fac = new GeometryFactory();
        this.geom = fac.createPoint(new Coordinate(10.0, 10.0));
        Diff diff = new Diff();
        diff.add("1", SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"diff1", this.geom}, (String)"1"));
        diff.modify("original", SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"diff2", this.geom}, (String)"original"));
        TestReader reader = new TestReader(this.type, SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"original", this.geom}, (String)"original"));
        this.writer = new DiffFeatureWriter(reader, diff){

            protected void fireNotification(int eventType, ReferencedEnvelope bounds) {
            }
        };
    }

    public void testRemove() throws Exception {
        this.writer.next();
        SimpleFeature feature = this.writer.next();
        this.writer.remove();
        DiffWriterTest.assertNull(this.writer.diff.added.get(feature.getID()));
    }

    public void testHasNext() throws Exception {
        DiffWriterTest.assertTrue((boolean)this.writer.hasNext());
        DiffWriterTest.assertEquals((int)2, (int)(this.writer.diff.added.size() + this.writer.diff.modified2.size()));
        this.writer.next();
        DiffWriterTest.assertTrue((boolean)this.writer.hasNext());
        DiffWriterTest.assertEquals((int)2, (int)(this.writer.diff.added.size() + this.writer.diff.modified2.size()));
        this.writer.next();
        DiffWriterTest.assertFalse((boolean)this.writer.hasNext());
        DiffWriterTest.assertEquals((int)2, (int)(this.writer.diff.added.size() + this.writer.diff.modified2.size()));
    }

    public void testWrite() throws IOException, Exception {
        while (this.writer.hasNext()) {
            this.writer.next();
        }
        SimpleFeature feature = this.writer.next();
        feature.setAttribute("name", (Object)"new1");
        this.writer.write();
        DiffWriterTest.assertEquals((int)2, (int)this.writer.diff.added.size());
        feature = this.writer.next();
        feature.setAttribute("name", (Object)"new2");
        this.writer.write();
        DiffWriterTest.assertEquals((int)3, (int)this.writer.diff.added.size());
    }
}

