/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.HashSet;
import org.geotools.feature.FeatureCollections;
import org.geotools.filter.function.FunctionTestSupport;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;

public class Collection_FunctionsTest
extends FunctionTestSupport {
    public Collection_FunctionsTest(String testName) {
        super(testName);
    }

    public void testInstance() {
        Function cmin = this.ff.function("Collection_Min", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        Collection_FunctionsTest.assertNotNull((Object)cmin);
    }

    public void testAverage() throws Exception {
        this.performNumberTest("Collection_Average", new Double(33.375));
    }

    public void testCount() throws Exception {
        this.performNumberTest("Collection_Count", new Integer(8));
    }

    public void testMin() throws Exception {
        this.performNumberTest("Collection_Min", new Integer(4));
    }

    public void testMedian() throws Exception {
        this.performNumberTest("Collection_Median", new Double(24.5));
    }

    public void testMax() throws Exception {
        this.performNumberTest("Collection_Max", new Integer(90));
    }

    public void testSum() throws Exception {
        this.performNumberTest("Collection_Sum", new Integer(267));
    }

    public void testUnique() throws Exception {
        HashSet<Integer> result = new HashSet<Integer>(8);
        result.add(new Integer(90));
        result.add(new Integer(4));
        result.add(new Integer(8));
        result.add(new Integer(43));
        result.add(new Integer(61));
        result.add(new Integer(20));
        result.add(new Integer(29));
        result.add(new Integer(12));
        this.performObjectTest("Collection_Unique", result);
    }

    public void performNumberTest(String functionName, Object expectedValue) throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(functionName, new Expression[]{exp});
        Object obj = func.evaluate((Object)this.featureCollection);
        Number result = (Number)obj;
        Number expected = (Number)expectedValue;
        Collection_FunctionsTest.assertEquals((double)expected.doubleValue(), (double)result.doubleValue(), (double)0.0);
    }

    public void performObjectTest(String functionName, Object expectedValue) throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(functionName, new Expression[]{exp});
        Object result = func.evaluate((Object)this.featureCollection);
        Collection_FunctionsTest.assertEquals((Object)expectedValue, (Object)result);
    }
}

