/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import org.geotools.filter.Capabilities;
import org.geotools.filter.visitor.AbstractCapabilitiesFilterSplitterTests;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;

public class CapabilitiesFilterSplitterTest
extends AbstractCapabilitiesFilterSplitterTests {
    private Capabilities simpleLogicalCaps = new Capabilities();
    private CapabilitiesFilterSplitter visitor;

    @Before
    public void setUp() throws Exception {
        this.simpleLogicalCaps.addAll(Capabilities.SIMPLE_COMPARISONS_OPENGIS);
        this.simpleLogicalCaps.addAll(Capabilities.LOGICAL_OPENGIS);
    }

    @Test
    public void testVisitBetweenFilter() throws Exception {
        PropertyIsBetween filter = this.ff.between((Expression)this.ff.literal(0), (Expression)this.ff.property("num"), (Expression)this.ff.literal(4));
        this.runTest((Filter)filter, this.newCapabilities(PropertyIsBetween.class), "num");
    }

    @Test
    public void testNullTransactionAccessor() throws Exception {
        this.accessor = null;
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo f2 = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)this.ff.and((Filter)f1, (Filter)f2), this.simpleLogicalCaps, "name");
    }

    @Test
    public void testVisitLogicalANDFilter() throws Exception {
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo f2 = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)this.ff.and((Filter)f1, (Filter)f2), this.simpleLogicalCaps, "name");
    }

    @Test
    public void testVisitLogicalNOTFilter() throws Exception {
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)this.ff.not((Filter)f1), this.simpleLogicalCaps, "name");
    }

    @Test
    public void testVisitLogicalORFilter() throws Exception {
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo f2 = this.createPropertyIsEqualToFilter("name", "jose");
        Or orFilter = this.ff.or((Filter)f1, (Filter)f2);
        this.runTest((Filter)orFilter, this.simpleLogicalCaps, "name");
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        f2 = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        orFilter = this.ff.or((Filter)f1, (Filter)f2);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPost());
    }

    @Test
    public void testMassOrFilter() throws Exception {
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        for (int i = 0; i < 10000; ++i) {
            filters.add(this.ff.equals((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)("" + i))));
        }
        Or orFilter = this.ff.or(filters);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
    }

    @Test
    public void testVisitCompareFilter() throws Exception {
        PropertyIsEqualTo f = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)f, Capabilities.SIMPLE_COMPARISONS_OPENGIS, "name");
    }

    @Test
    public void testVisitCompareFilterWithUpdateDifferentAttribute() throws Exception {
        PropertyIsEqualTo f = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo updateFilter = this.createPropertyIsEqualToFilter("name", "jose");
        this.accessor = new AbstractCapabilitiesFilterSplitterTests.TestAccessor();
        this.accessor.setUpdate("geom", (Filter)updateFilter);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((String)this.visitor.getFilterPost().toString(), (Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((String)this.visitor.getFilterPre().toString(), (Object)f, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testVisitLikeFilter() throws Exception {
        PropertyIsLike filter = this.ff.like((Expression)this.ff.property("name"), "j*", "*", "?", "\\");
        this.runTest((Filter)filter, this.newCapabilities(PropertyIsLike.class), "name");
    }

    @Test
    public void testVisitNullFilter() throws Exception {
        PropertyIsNull filter = this.ff.isNull((Expression)this.ff.property("name"));
        this.runTest((Filter)filter, this.newCapabilities(PropertyIsNull.class), "name");
    }

    @Test
    public void testVisitFidFilter() throws Exception {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("david"));
        Id filter = this.ff.id(ids);
        this.visitor = this.newVisitor(this.newCapabilities(Id.class));
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo filter = this.createFunctionFilter();
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        this.simpleLogicalCaps.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionANDGeometryFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        BBOX geomFilter = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        And andFilter = this.ff.and((Filter)funtionFilter, (Filter)geomFilter);
        andFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)funtionFilter.toString(), (Object)this.visitor.getFilterPost().toString());
        Assert.assertEquals((Object)geomFilter.toString(), (Object)this.visitor.getFilterPre().toString());
        this.simpleLogicalCaps.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        andFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)andFilter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionORGeometryFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        BBOX geomFilter = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        Or orFilter = this.ff.or((Filter)funtionFilter, (Filter)geomFilter);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPost());
        this.simpleLogicalCaps.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionNOTFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        Not not = this.ff.not((Filter)funtionFilter);
        not.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)not, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        this.simpleLogicalCaps.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        not.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)not, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testNullParentNullAccessor() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.simpleLogicalCaps.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        BBOX geomFilter = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        Or orFilter = this.ff.or((Filter)funtionFilter, (Filter)geomFilter);
        this.visitor = new CapabilitiesFilterSplitter(new Capabilities(), null, null);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPost());
        this.visitor = new CapabilitiesFilterSplitter(this.simpleLogicalCaps, null, null);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testComplicatedOrFilter() throws Exception {
        PropertyIsEqualTo c1 = this.ff.equals((Expression)this.ff.property("eventstatus"), (Expression)this.ff.literal((Object)"deleted"));
        PropertyIsEqualTo c2 = this.ff.equals((Expression)this.ff.property("eventtype"), (Expression)this.ff.literal((Object)"road hazard"));
        PropertyIsEqualTo c3 = this.ff.equals((Expression)this.ff.property("eventtype"), (Expression)this.ff.literal((Object)"area warning"));
        BBOX g = this.ff.bbox("geom", 0.0, 180.0, 0.0, 90.0, "");
        Or f = this.ff.or((Filter)c2, (Filter)c3);
        f = this.ff.and((Filter)this.ff.not((Filter)c1), (Filter)f);
        f = this.ff.and((Filter)f, (Filter)g);
        this.simpleLogicalCaps.addType(BBOX.class);
        this.simpleLogicalCaps.addName(this.testFunction.getName(), this.testFunction.getParameters().size());
        this.visitor = new CapabilitiesFilterSplitter(this.simpleLogicalCaps, null, null);
        f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)f, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        this.visitor = new CapabilitiesFilterSplitter(this.simpleLogicalCaps, null, new ClientTransactionAccessor(){

            public Filter getDeleteFilter() {
                return null;
            }

            public Filter getUpdateFilter(String attributePath) {
                if (attributePath.equals("eventtype")) {
                    HashSet<FeatureId> ids = new HashSet<FeatureId>();
                    ids.add(CapabilitiesFilterSplitterTest.this.ff.featureId("fid"));
                    return CapabilitiesFilterSplitterTest.this.ff.id(ids);
                }
                return null;
            }
        });
        f.accept((FilterVisitor)this.visitor, null);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("fid"));
        Assert.assertEquals((Object)f, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)this.ff.or((Filter)f, (Filter)this.ff.id(ids)), (Object)this.visitor.getFilterPre());
    }
}

