/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.AbstractPostPreProcessFilterSplittingVisitorTests;
import org.opengis.filter.Filter;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.Geometry;

public class PostPreProcessFilterSplittingVisitorSpatialTest
extends AbstractPostPreProcessFilterSplittingVisitorTests {
    private Geometry geom = new AbstractPostPreProcessFilterSplittingVisitorTests.MockGeometryImpl();

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBBOX() throws Exception {
        BBOX f = this.ff.bbox("geom", 10.0, 10.0, 20.0, 20.0, "");
        this.runTest((Filter)f, new FilterCapabilities(BBOX.class), "geom");
    }

    public void testBEYOND() throws Exception {
        Beyond f = this.ff.beyond("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, new FilterCapabilities(Beyond.class), "geom");
    }

    public void testCONTAINS() throws Exception {
        Contains f = this.ff.contains("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Contains.class), "geom");
    }

    public void testCROSSES() throws Exception {
        Crosses f = this.ff.crosses("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Crosses.class), "geom");
    }

    public void testDISJOINT() throws Exception {
        Disjoint f = this.ff.disjoint("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Disjoint.class), "geom");
    }

    public void tesDWITHINt() throws Exception {
        DWithin f = this.ff.dwithin("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, new FilterCapabilities(DWithin.class), "geom");
    }

    public void testEQUALS() throws Exception {
        Equals f = this.ff.equals("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Equals.class), "geom");
    }

    public void testINTERSECTS() throws Exception {
        Intersects f = this.ff.intersects("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Intersects.class), "geom");
    }

    public void testOVERLAPS() throws Exception {
        Overlaps f = this.ff.overlaps("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Overlaps.class), "geom");
    }

    public void testTOUCHES() throws Exception {
        Touches f = this.ff.touches("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Touches.class), "geom");
    }

    public void testWITHIN() throws Exception {
        Within f = this.ff.within("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Within.class), "geom");
    }
}

