/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.FontImpl;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.StyleFactoryImpl2;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.AnchorPoint;
import org.opengis.style.Displacement;
import org.opengis.style.Font;
import org.opengis.style.StyleVisitor;

public class StyleTest {
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    static StyleFactoryImpl2 sf = new StyleFactoryImpl2(ff);

    @Test
    public void displacement() {
        Assert.assertNull((Object)DisplacementImpl.cast(null));
        DisplacementImpl displacement = new DisplacementImpl();
        displacement.setDisplacementX(1.0);
        displacement.setDisplacementY(1.0);
        Assert.assertSame((Object)displacement, (Object)DisplacementImpl.cast((Displacement)displacement));
        Assert.assertEquals((Object)displacement, (Object)sf.displacement((Expression)ff.literal(1.0), (Expression)ff.literal(1.0)));
        Displacement external = new Displacement(){

            public Expression getDisplacementY() {
                return ff.literal(1.0);
            }

            public Expression getDisplacementX() {
                return ff.literal(1.0);
            }

            public Object accept(StyleVisitor visitor, Object data) {
                return visitor.visit((Displacement)this, data);
            }
        };
        displacement = DisplacementImpl.cast((Displacement)external);
        Assert.assertEquals((Object)ff.literal(1.0), (Object)displacement.getDisplacementX());
    }

    @Test
    public void font() throws Exception {
        ArrayList<Literal> family = new ArrayList<Literal>();
        family.add(ff.literal((Object)"ariel"));
        family.add(ff.literal((Object)"Helvetica"));
        family.add(ff.literal((Object)"sanserif"));
        Literal style = ff.literal((Object)"noraml");
        Literal weight = ff.literal((Object)"normal");
        Literal size = ff.literal(12);
        FontImpl font = sf.font(family, (Expression)style, (Expression)weight, (Expression)size);
        Assert.assertEquals(family, (Object)font.getFamily());
        Assert.assertEquals((Object)style, (Object)font.getStyle());
        Assert.assertEquals((Object)weight, (Object)font.getWeight());
        Assert.assertEquals((Object)size, (Object)font.getSize());
        Assert.assertSame((Object)font.getFontStyle(), (Object)font.getStyle());
        Assert.assertSame((Object)font.getFontFamily(), family.get(0));
        Assert.assertSame((Object)font.getFontWeight(), (Object)font.getWeight());
        Assert.assertSame((Object)font.getFontSize(), (Object)font.getSize());
        FontImpl cast = FontImpl.cast((Font)font);
        Assert.assertSame((Object)cast, (Object)font);
    }

    @Test
    public void graphic() throws Exception {
        ArrayList<MarkImpl> symbols = new ArrayList<MarkImpl>();
        symbols.add(sf.mark((Expression)ff.literal((Object)"square"), null, null));
        symbols.add(sf.mark((Expression)ff.literal((Object)"circle"), null, null));
        Expression opacity = null;
        Expression size = null;
        Expression rotation = null;
        AnchorPoint anchor = null;
        Displacement disp = null;
        GraphicImpl graphic = sf.graphic(symbols, opacity, size, rotation, anchor, disp);
        Assert.assertNotNull((Object)graphic);
    }
}

