/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import junit.framework.TestCase;
import org.geotools.util.CommonsConverterFactory;

public class CommonsConverterFactoryTest
extends TestCase {
    CommonsConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new CommonsConverterFactory();
    }

    public void testStringNumberConversion() throws Exception {
        CommonsConverterFactoryTest.assertEquals((Object)12, (Object)this.convert("12", Integer.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("12.0", Integer.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("12.5", Integer.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("9223372036854775807", Integer.class));
        CommonsConverterFactoryTest.assertEquals((Object)Long.MAX_VALUE, (Object)this.convert("9223372036854775807", Long.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("1e100", Long.class));
        CommonsConverterFactoryTest.assertEquals(null, (Object)this.convert("12.5", Long.class));
        CommonsConverterFactoryTest.assertEquals((Object)9.223372036854776E18, (Object)this.convert("9223372036854775807", Double.class));
        CommonsConverterFactoryTest.assertEquals((Object)1.0E100, (Object)this.convert("1e100", Double.class));
        CommonsConverterFactoryTest.assertEquals((Object)12.5, (Object)this.convert("12.5", Double.class));
    }

    Object convert(Object source, Class target) throws Exception {
        return this.factory.createConverter(source.getClass(), target, null).convert(source, target);
    }
}

