/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureDiff {
    public static final int INSERTED = 0;
    public static final int UPDATED = 1;
    public static final int DELETED = 2;
    String ID;
    int state;
    List changedAttributes;
    SimpleFeature feature;
    SimpleFeature oldFeature;

    FeatureDiff(SimpleFeature oldFeature, SimpleFeature newFeature) {
        if (oldFeature == null && newFeature == null) {
            throw new IllegalArgumentException("Both features are null, that's not a diff!");
        }
        this.ID = oldFeature != null ? oldFeature.getID() : newFeature.getID();
        this.feature = newFeature;
        this.oldFeature = oldFeature;
        this.changedAttributes = Collections.EMPTY_LIST;
        if (oldFeature == null) {
            this.state = 0;
        } else if (newFeature == null) {
            this.state = 2;
        } else {
            this.state = 1;
            ArrayList<String> changedAttributes = new ArrayList<String>();
            for (int i = 0; i < oldFeature.getAttributeCount(); ++i) {
                String attName = oldFeature.getFeatureType().getDescriptor(i).getLocalName();
                Object toAttribute = newFeature.getAttribute(attName);
                Object fromAttribute = oldFeature.getAttribute(attName);
                if (DataUtilities.attributesEqual((Object)fromAttribute, (Object)toAttribute)) continue;
                changedAttributes.add(attName);
            }
            this.changedAttributes = Collections.unmodifiableList(changedAttributes);
        }
    }

    public List getChangedAttributes() {
        return this.changedAttributes;
    }

    public String getID() {
        return this.ID;
    }

    public int getState() {
        return this.state;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public SimpleFeature getOldFeature() {
        return this.oldFeature;
    }
}

