/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.RenderingHints;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.postgis.AbstractPostgisDataTestCase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Postgis3DTest
extends AbstractPostgisDataTestCase {
    protected static final String LINE3D = "line3d";
    protected static final String POLY3D = "poly3d";
    protected static final String POINT3D = "point3d";
    protected static final String ID = "id";
    protected static final String GEOM = "geom";
    protected static final String NAME = "name";
    protected static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType poly3DType;
    protected SimpleFeatureType line3DType;
    protected CoordinateReferenceSystem epsg4326;

    public Postgis3DTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JDBCDataStore data = (JDBCDataStore)this.data;
        this.line3DType = DataUtilities.createType((String)(data.getNameSpace().toString() + "." + LINE3D), (String)"id:0,geom:LineString:srid=4326,name:String");
        this.line3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.poly3DType = DataUtilities.createType((String)(data.getNameSpace().toString() + "." + POLY3D), (String)"id:0,geom:Polygon:srid=4326,name:String");
        this.poly3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.epsg4326 = CRS.decode((String)"EPSG:4326");
    }

    protected void setupDbTables() throws Exception {
        this.setUpLine3DTable();
        this.setUpPoint3DTable();
        this.dropPoly3DTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpLine3DTable() throws Exception {
        Statement s;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s = conn.createStatement();
            s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','line3d','geom')");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("DROP TABLE " + this.f.schema + ".line3d CASCADE");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("CREATE TABLE " + this.f.schema + ".line3d (id int primary key)");
            s.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'line3d', 'geom', 4326, 'LINESTRING', 3);");
            s.execute("ALTER TABLE " + this.f.schema + ".line3d add name varchar;");
            s.execute("INSERT INTO " + this.f.schema + ".line3d (id,geom,name) VALUES (0," + "GeometryFromText('LINESTRING(1 1 0, 2 2 0, 4 2 1, 5 1 1)', 4326), 'l1')");
            s.execute("INSERT INTO " + this.f.schema + ".line3d (id,geom,name) VALUES (1," + "GeometryFromText('LINESTRING(3 0 1, 3 2 2, 3 3 3, 3 4 5)', 4326), 'l2')");
            s.execute("VACUUM ANALYZE " + this.f.schema + ".line3d");
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpPoint3DTable() throws Exception {
        Statement s;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s = conn.createStatement();
            s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','point3d','geom')");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("DROP TABLE " + this.f.schema + ".point3d CASCADE");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("CREATE TABLE " + this.f.schema + ".point3d (id int primary key)");
            s.execute("SELECT AddGeometryColumn('" + this.f.schema + "', 'point3d', 'geom', 4326, 'POINT', 3);");
            s.execute("ALTER TABLE " + this.f.schema + ".point3d add name varchar;");
            s.execute("INSERT INTO " + this.f.schema + ".point3d (id,geom,name) VALUES (0," + "GeometryFromText('POINT(1 1 1)', 4326), 'p1')");
            s.execute("INSERT INTO " + this.f.schema + ".point3d (id,geom,name) VALUES (1," + "GeometryFromText('POINT(3 0 1)', 4326), 'p2')");
            s.execute("VACUUM ANALYZE " + this.f.schema + ".point3d");
        }
        finally {
            conn.close();
        }
    }

    protected void dropPoly3DTable() throws Exception {
        Statement s;
        Connection conn = this.pool.getConnection();
        conn.setAutoCommit(true);
        try {
            s = conn.createStatement();
            s.execute("SELECT dropgeometrycolumn( '" + this.f.schema + "','poly3d','geom')");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            s = conn.createStatement();
            s.execute("DROP TABLE " + this.f.schema + ".poly3d CASCADE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.data.getSchema(LINE3D);
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        Postgis3DTest.assertEquals((Object)new Integer(4326), (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        Postgis3DTest.assertEquals((Object)3, schema.getGeometryDescriptor().getUserData().get(Hints.COORDINATE_DIMENSION));
    }

    public void testReadPoint() throws Exception {
        SimpleFeatureCollection fc = this.data.getFeatureSource(POINT3D).getFeatures();
        SimpleFeatureIterator fr = fc.features();
        Postgis3DTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature feature = (SimpleFeature)fr.next();
        Postgis3DTest.assertEquals((Object)3, feature.getType().getGeometryDescriptor().getUserData().get(Hints.COORDINATE_DIMENSION));
        Point p = (Point)feature.getDefaultGeometry();
        Postgis3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 1.0).equals3D(p.getCoordinate()));
        fr.close();
    }

    public void testReadPoint2D() throws Exception {
        DefaultQuery q = new DefaultQuery(POINT3D);
        q.setHints(new Hints((RenderingHints.Key)Hints.FEATURE_2D, (Object)true));
        SimpleFeatureCollection fc = this.data.getFeatureSource(POINT3D).getFeatures((Query)q);
        SimpleFeatureIterator fr = fc.features();
        Postgis3DTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature feature = (SimpleFeature)fr.next();
        Postgis3DTest.assertEquals((Object)2, feature.getType().getGeometryDescriptor().getUserData().get(Hints.COORDINATE_DIMENSION));
        Point p = (Point)feature.getDefaultGeometry();
        Postgis3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, Double.NaN).equals3D(p.getCoordinate()));
        fr.close();
    }

    public void testReadLine() throws Exception {
        SimpleFeatureCollection fc = this.data.getFeatureSource(LINE3D).getFeatures();
        SimpleFeatureIterator fr = fc.features();
        Postgis3DTest.assertTrue((boolean)fr.hasNext());
        LineString ls = (LineString)((SimpleFeature)fr.next()).getDefaultGeometry();
        Postgis3DTest.assertEquals((int)4, (int)ls.getCoordinates().length);
        Postgis3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 0.0).equals3D(ls.getCoordinateN(0)));
        Postgis3DTest.assertTrue((boolean)new Coordinate(2.0, 2.0, 0.0).equals3D(ls.getCoordinateN(1)));
        Postgis3DTest.assertTrue((boolean)new Coordinate(4.0, 2.0, 1.0).equals3D(ls.getCoordinateN(2)));
        Postgis3DTest.assertTrue((boolean)new Coordinate(5.0, 1.0, 1.0).equals3D(ls.getCoordinateN(3)));
        fr.close();
    }

    public void testWriteLine() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0, 0.0), new Coordinate(1.0, 1.0, 1.0)});
        SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.line3DType, (Object[])new Object[]{2, ls, "l3"}, null);
        SimpleFeatureStore fs = (SimpleFeatureStore)this.data.getFeatureSource(LINE3D);
        List fids = fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)newFeature));
        SimpleFeatureIterator fi = fs.getFeatures((Filter)FF.id(new HashSet(fids))).features();
        Postgis3DTest.assertTrue((boolean)fi.hasNext());
        SimpleFeature f = (SimpleFeature)fi.next();
        Postgis3DTest.assertTrue((boolean)ls.equals((Geometry)f.getDefaultGeometry()));
        fi.close();
    }

    public void testCreateSchemaAndInsert() throws Exception {
        this.data.createSchema((FeatureType)this.poly3DType);
        SimpleFeatureType actualSchema = this.data.getSchema(POLY3D);
        this.assertFeatureTypesEqual(this.poly3DType, actualSchema);
        GeometryFactory gf = new GeometryFactory();
        LinearRing shell = gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0, 0.0), new Coordinate(1.0, 1.0, 1.0), new Coordinate(1.0, 0.0, 1.0), new Coordinate(0.0, 0.0, 0.0)});
        Polygon poly = gf.createPolygon(shell, null);
        FeatureWriter fw = this.data.getFeatureWriterAppend(POLY3D, Transaction.AUTO_COMMIT);
        SimpleFeature f = (SimpleFeature)fw.next();
        f.setAttribute(ID, (Object)0);
        f.setAttribute(GEOM, (Object)poly);
        f.setAttribute(NAME, (Object)"3dpolygon!");
        fw.write();
        fw.close();
        FeatureReader fr = this.data.getFeatureReader((Query)new DefaultQuery(POLY3D), Transaction.AUTO_COMMIT);
        Postgis3DTest.assertTrue((boolean)fr.hasNext());
        f = (SimpleFeature)fr.next();
        Postgis3DTest.assertTrue((boolean)poly.equals((Geometry)f.getDefaultGeometry()));
        fr.close();
    }

    public void testBounds() throws Exception {
        ReferencedEnvelope env = this.data.getFeatureSource(LINE3D).getBounds();
        Envelope expected = new Envelope(1.0, 5.0, 0.0, 4.0);
        Postgis3DTest.assertEquals((Object)expected, (Object)env);
        Postgis3DTest.assertEquals((Object)this.epsg4326, (Object)env.getCoordinateReferenceSystem());
    }

    public void testRendererBehaviour() throws Exception {
        SimpleFeatureSource fs = this.data.getFeatureSource(LINE3D);
        Postgis3DTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        DefaultQuery q = new DefaultQuery(LINE3D);
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        FeatureCollection fc = fs.getFeatures((Query)q);
        FeatureType fcSchema = fc.getSchema();
        Postgis3DTest.assertEquals((Object)this.epsg4326, (Object)fcSchema.getCoordinateReferenceSystem());
        Postgis3DTest.assertEquals((Object)this.epsg4326, (Object)fcSchema.getGeometryDescriptor().getCoordinateReferenceSystem());
        LineString expected = new GeometryFactory().createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(4.0, 2.0), new Coordinate(5.0, 1.0)});
        FeatureReader fr = this.data.getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
        Postgis3DTest.assertEquals((Object)this.epsg4326, (Object)((SimpleFeatureType)fr.getFeatureType()).getCoordinateReferenceSystem());
        Postgis3DTest.assertEquals((Object)this.epsg4326, (Object)((SimpleFeatureType)fr.getFeatureType()).getGeometryDescriptor().getCoordinateReferenceSystem());
        Postgis3DTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        Postgis3DTest.assertTrue((boolean)expected.equals((Geometry)f.getDefaultGeometry()));
        fr.close();
    }

    protected void assertFeatureTypesEqual(SimpleFeatureType expected, SimpleFeatureType actual) {
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            this.assertAttributesEqual(expectedAttribute, actualAttribute);
        }
        if (expected.getGeometryDescriptor() != null) {
            GeometryDescriptor dg = actual.getGeometryDescriptor();
            Postgis3DTest.assertTrue((boolean)dg.isNillable());
            Postgis3DTest.assertEquals((int)0, (int)dg.getMinOccurs());
        }
    }

    protected void assertAttributesEqual(AttributeDescriptor expected, AttributeDescriptor actual) {
        Postgis3DTest.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Postgis3DTest.assertEquals((int)expected.getMinOccurs(), (int)actual.getMinOccurs());
        Postgis3DTest.assertEquals((int)expected.getMaxOccurs(), (int)actual.getMaxOccurs());
        Postgis3DTest.assertEquals((boolean)expected.isNillable(), (boolean)actual.isNillable());
        Postgis3DTest.assertEquals((Object)expected.getDefaultValue(), (Object)actual.getDefaultValue());
        AttributeType texpected = expected.getType();
        AttributeType tactual = actual.getType();
        if (Number.class.isAssignableFrom(texpected.getBinding())) {
            Postgis3DTest.assertTrue((boolean)Number.class.isAssignableFrom(tactual.getBinding()));
        } else if (Geometry.class.isAssignableFrom(texpected.getBinding())) {
            Postgis3DTest.assertTrue((boolean)Geometry.class.isAssignableFrom(tactual.getBinding()));
        } else {
            Postgis3DTest.assertTrue((boolean)texpected.getBinding().isAssignableFrom(tactual.getBinding()));
        }
    }

    protected boolean areCRSEqual(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        if (crs1 == null && crs2 == null) {
            return true;
        }
        if (crs1 == null) {
            return false;
        }
        return crs1.equals(crs2);
    }
}

