/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.AbstractPostgisOnlineTestCase;
import org.geotools.data.postgis.fidmapper.PostgisFIDMapperFactory;
import org.opengis.feature.simple.SimpleFeature;

public class PostgisFeatureWriterOnlineTest
extends AbstractPostgisOnlineTestCase {
    public void testWrite() throws Exception {
        if (((PostgisFIDMapperFactory)this.ds.getFIDMapperFactory()).isReturningTypedFIDMapper()) {
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest1.1", (String)this.attemptWrite("tmp_pgtest1"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest1.2", (String)this.attemptWrite("tmp_pgtest1"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest2.1001", (String)this.attemptWrite("tmp_pgtest2"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest2.1002", (String)this.attemptWrite("tmp_pgtest2"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest3.1", (String)this.attemptWrite("tmp_pgtest3"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest3.2", (String)this.attemptWrite("tmp_pgtest3"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest4.1000001", (String)this.attemptWrite("tmp_pgtest4"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest4.1000002", (String)this.attemptWrite("tmp_pgtest4"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest 5.1", (String)this.attemptWrite("tmp_pgtest 5"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest 5.2", (String)this.attemptWrite("tmp_pgtest 5"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest 6.1001", (String)this.attemptWrite("tmp_pgtest 6"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"tmp_pgtest 6.1002", (String)this.attemptWrite("tmp_pgtest 6"));
        } else {
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1", (String)this.attemptWrite("tmp_pgtest1"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"2", (String)this.attemptWrite("tmp_pgtest1"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1001", (String)this.attemptWrite("tmp_pgtest2"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1002", (String)this.attemptWrite("tmp_pgtest2"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1", (String)this.attemptWrite("tmp_pgtest3"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"2", (String)this.attemptWrite("tmp_pgtest3"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1000001", (String)this.attemptWrite("tmp_pgtest4"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1000002", (String)this.attemptWrite("tmp_pgtest4"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1", (String)this.attemptWrite("tmp_pgtest 5"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"2", (String)this.attemptWrite("tmp_pgtest 5"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1001", (String)this.attemptWrite("tmp_pgtest 6"));
            PostgisFeatureWriterOnlineTest.assertEquals((String)"1002", (String)this.attemptWrite("tmp_pgtest 6"));
        }
    }

    public String attemptWrite(String table) throws Exception {
        SimpleFeature feature;
        DefaultTransaction transaction = new DefaultTransaction("attemptWriteFW");
        FeatureWriter writer = this.ds.getFeatureWriter(table, (Transaction)transaction);
        while (writer.hasNext()) {
            feature = (SimpleFeature)writer.next();
        }
        feature = (SimpleFeature)writer.next();
        feature.setAttribute(0, (Object)"test");
        writer.write();
        String id = feature.getID();
        transaction.commit();
        transaction.close();
        return id;
    }
}

