/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.data.postgis.PostgisTests;

public class PostgisDataStoreFactoryOnlineTest
extends TestCase {
    static PostgisDataStoreFactory factory = new PostgisDataStoreFactory();
    Map remote;
    Map local;
    private PostgisTests.Fixture f;

    protected void setUp() throws Exception {
        this.f = PostgisTests.newFixture();
        this.remote = new HashMap();
        this.remote.put("dbtype", "postgis");
        this.remote.put("charset", "");
        this.remote.put("host", this.f.host);
        this.remote.put("port", this.f.port);
        this.remote.put("database", this.f.database);
        this.remote.put("user", this.f.user);
        this.remote.put("passwd", this.f.password);
        this.remote.put("namespace", this.f.namespace);
        super.setUp();
    }

    public void testRemote() throws Exception {
        Map map = this.remote;
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)this.f.database, (Object)PostgisDataStoreFactory.DATABASE.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)"postgis", (Object)PostgisDataStoreFactory.DBTYPE.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)this.f.host, (Object)PostgisDataStoreFactory.HOST.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)this.f.namespace, (Object)PostgisDataStoreFactory.NAMESPACE.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)this.f.password, (Object)PostgisDataStoreFactory.PASSWD.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)this.f.port, (Object)PostgisDataStoreFactory.PORT.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertEquals((Object)this.f.user, (Object)PostgisDataStoreFactory.USER.lookUp(map));
        PostgisDataStoreFactoryOnlineTest.assertTrue((String)"canProcess", (boolean)factory.canProcess(map));
        try {
            DataStore temp = factory.createDataStore(map);
            PostgisDataStoreFactoryOnlineTest.assertNotNull((String)"created", (Object)temp);
        }
        catch (DataSourceException expected) {
            PostgisDataStoreFactoryOnlineTest.assertTrue((boolean)expected.getMessage().startsWith("Connection failed:"));
        }
    }
}

