/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import junit.framework.TestCase;
import org.easymock.classextension.EasyMock;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.data.postgis.fidmapper.OIDFidMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class PostgisSQLBuilderTest
extends TestCase {
    PostgisSQLBuilder builder;
    private JDBCDataStoreConfig config;

    protected void setUp() throws Exception {
        this.config = (JDBCDataStoreConfig)EasyMock.createMock(JDBCDataStoreConfig.class);
        this.builder = new PostgisSQLBuilder(4326, this.config);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSqlFromSchemaDisabled() {
        this.builder.setSchemaEnabled(false);
        StringBuffer sql = new StringBuffer();
        this.builder.sqlFrom(sql, "typeName");
        PostgisSQLBuilderTest.assertEquals((String)" FROM \"typeName\"", (String)sql.toString());
    }

    public void testSqlFromSchemaEnabled() {
        this.builder.setSchemaEnabled(true);
        EasyMock.expect((Object)this.config.getDatabaseSchemaName()).andReturn((Object)"schema");
        EasyMock.replay((Object[])new Object[]{this.config});
        StringBuffer sql = new StringBuffer();
        this.builder.sqlFrom(sql, "typeName");
        PostgisSQLBuilderTest.assertEquals((String)" FROM \"schema\".\"typeName\"", (String)sql.toString());
        EasyMock.verify((Object[])new Object[]{this.config});
    }

    public void testSqlWhere() throws SQLEncoderException {
        StringBuffer sql = new StringBuffer();
        org.geotools.filter.Filter preFilter = null;
        this.builder.sqlWhere(sql, preFilter);
        PostgisSQLBuilderTest.assertEquals((String)"", (String)sql.toString());
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        preFilter = (org.geotools.filter.Filter)filterFactory.bbox("the_geom", 0.0, 0.0, 1.0, 1.0, null);
        SQLEncoder encoder = (SQLEncoder)EasyMock.createMock(SQLEncoder.class);
        encoder.setFeatureType(null);
        EasyMock.expect((Object)encoder.encode((Filter)EasyMock.same((Object)preFilter))).andReturn((Object)"encoded");
        EasyMock.replay((Object[])new Object[]{encoder});
        this.builder = new PostgisSQLBuilder(encoder, this.config);
        this.builder.sqlWhere(sql, preFilter);
        PostgisSQLBuilderTest.assertEquals((String)" encoded", (String)sql.toString());
        EasyMock.verify((Object[])new Object[]{encoder});
    }

    public void testBuildSQLQueryNoOffsetNoLimit() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = null;
        Integer offset = null;
        Integer limit = null;
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\"", (String)sql);
    }

    public void testBuildSQLQueryOrderBy() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = new SortBy[]{CommonFactoryFinder.getFilterFactory(null).sort("attribute", SortOrder.DESCENDING)};
        Integer offset = null;
        Integer limit = null;
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY \"attribute\" DESC", (String)sql);
        sortBy = new SortBy[]{SortBy.NATURAL_ORDER};
        sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY oid ASC", (String)sql);
        sortBy = new SortBy[]{SortBy.REVERSE_ORDER};
        sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY oid DESC", (String)sql);
    }

    public void testBuildSQLQueryOffset() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = null;
        Integer offset = new Integer(15);
        Integer limit = null;
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY oid ASC OFFSET 15", (String)sql);
    }

    public void testBuildSQLQueryOffsetOrderBy() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = new SortBy[]{CommonFactoryFinder.getFilterFactory(null).sort("attribute", SortOrder.DESCENDING)};
        Integer offset = new Integer(15);
        Integer limit = null;
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY \"attribute\" DESC, oid ASC OFFSET 15", (String)sql);
    }

    public void testBuildSQLQueryMaxFeatures() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = null;
        Integer offset = null;
        Integer limit = new Integer(50);
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" LIMIT 50", (String)sql);
    }

    public void testBuildSQLQueryOffsetMaxFeatures() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = null;
        Integer offset = new Integer(15);
        Integer limit = new Integer(30);
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY oid ASC OFFSET 15 LIMIT 30", (String)sql);
    }

    public void testBuildSQLQueryOffsetMaxFeaturesOrderBy() throws SQLEncoderException {
        OIDFidMapper mapper = new OIDFidMapper();
        SortBy[] sortBy = new SortBy[]{CommonFactoryFinder.getFilterFactory(null).sort("attribute", SortOrder.DESCENDING)};
        Integer offset = new Integer(15);
        Integer limit = new Integer(30);
        String sql = this.buildSQLQuery((FIDMapper)mapper, sortBy, offset, limit);
        String baseSelect = "SELECT \"oid\", \"attribute\" FROM \"typeName\"";
        PostgisSQLBuilderTest.assertEquals((String)"SELECT \"oid\", \"attribute\" FROM \"typeName\" ORDER BY \"attribute\" DESC, oid ASC OFFSET 15 LIMIT 30", (String)sql);
    }

    private String buildSQLQuery(FIDMapper mapper, SortBy[] sortBy, Integer offset, Integer limit) throws SQLEncoderException {
        AttributeTypeImpl type = new AttributeTypeImpl((Name)new NameImpl("attType"), String.class, false, false, null, null, null);
        AttributeDescriptorImpl attribute = new AttributeDescriptorImpl((AttributeType)type, (Name)new NameImpl("attribute"), 0, 1, true, null);
        AttributeDescriptor[] attrTypes = new AttributeDescriptor[]{attribute};
        String typeName = "typeName";
        Filter filter = null;
        this.builder.setSchemaEnabled(false);
        String sql = this.builder.buildSQLQuery(typeName, mapper, attrTypes, filter, sortBy, offset, limit);
        return sql;
    }
}

