/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.geotools.data.postgis.PostgisDataStoreFactory;

public class PostgisTests {
    public static Fixture newFixture(String props) throws IOException {
        PropertyResourceBundle resource = new PropertyResourceBundle(PostgisTests.class.getResourceAsStream(props));
        Fixture f = new Fixture();
        f.namespace = resource.getString("namespace");
        f.host = resource.getString("host");
        f.port = Integer.valueOf(resource.getString("port"));
        f.database = resource.getString("database");
        f.user = resource.getString("user");
        f.password = resource.getString("password");
        f.schema = resource.getString("schema");
        if (f.schema == null || "".equals(f.schema.trim())) {
            f.schema = "public";
        }
        f.wkbEnabled = null;
        f.looseBbox = null;
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (key.equalsIgnoreCase("wkbEnabled")) {
                f.wkbEnabled = new Boolean(resource.getString("wkbEnabled"));
                continue;
            }
            if (!key.equalsIgnoreCase("looseBbox")) continue;
            f.looseBbox = new Boolean(resource.getString("looseBbox"));
        }
        return f;
    }

    public static Fixture newFixture() throws IOException {
        return PostgisTests.newFixture("fixture.properties");
    }

    public static Map getParams(Fixture f) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PostgisDataStoreFactory.DBTYPE.key, "postgis");
        params.put(PostgisDataStoreFactory.HOST.key, f.host);
        params.put(PostgisDataStoreFactory.PORT.key, f.port);
        params.put(PostgisDataStoreFactory.DATABASE.key, f.database);
        params.put(PostgisDataStoreFactory.USER.key, f.user);
        params.put(PostgisDataStoreFactory.PASSWD.key, f.password);
        params.put(PostgisDataStoreFactory.SCHEMA.key, f.schema);
        if (f.wkbEnabled != null) {
            params.put(PostgisDataStoreFactory.WKBENABLED.key, f.wkbEnabled);
        }
        if (f.looseBbox != null) {
            params.put(PostgisDataStoreFactory.LOOSEBBOX.key, f.looseBbox);
        }
        return params;
    }

    public static Map getParams(String fixtureFile) throws IOException {
        Fixture f = PostgisTests.newFixture(fixtureFile);
        return PostgisTests.getParams(f);
    }

    public static class Fixture {
        public String namespace;
        public String host;
        public String database;
        public Integer port;
        public String user;
        public String password;
        public String schema;
        public Boolean wkbEnabled;
        public Boolean looseBbox;
    }
}

