/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.collection;

import org.geotools.data.jdbc.JDBCFeatureCollection;
import org.geotools.data.postgis.AbstractPostgisDataTestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FunctionExpression;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class FeatureCollectionAggregateVisitorTests
extends AbstractPostgisDataTestCase {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    JDBCFeatureCollection roads;
    JDBCFeatureCollection rivers;
    PropertyName roadsId;
    PropertyName riverFlow;

    public FeatureCollectionAggregateVisitorTests(String test) {
        super(test);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.roads = (JDBCFeatureCollection)this.data.getFeatureSource("road").getFeatures();
        this.rivers = (JDBCFeatureCollection)this.data.getFeatureSource("river").getFeatures();
        this.roadsId = this.ff.property("id");
        this.riverFlow = this.ff.property("flow");
    }

    public void testSum() throws Exception {
        SumVisitor sumVisitor = new SumVisitor((Expression)this.roadsId);
        this.roads.accepts((FeatureVisitor)sumVisitor, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)6, (int)sumVisitor.getResult().toInt());
        Literal one = this.ff.literal(1);
        Add add = this.ff.add((Expression)this.roadsId, (Expression)one);
        SumVisitor sumInt = new SumVisitor((Expression)add);
        this.roads.accepts((FeatureVisitor)sumInt, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)9, (int)sumInt.getResult().toInt());
        Add addFloat = this.ff.add((Expression)this.riverFlow, (Expression)one);
        SumVisitor sumFloat = new SumVisitor((Expression)addFloat);
        this.rivers.accepts((FeatureVisitor)sumFloat, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.rivers.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((double)9.5, (double)sumFloat.getResult().toDouble(), (double)0.0);
    }

    public void testCount() throws Exception {
        CountVisitor countVisitor = new CountVisitor();
        this.roads.accepts((FeatureVisitor)countVisitor, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)3, (int)countVisitor.getResult().toInt());
    }

    public void testMinMax() throws Exception {
        MinVisitor minVisitor = new MinVisitor((Expression)this.roadsId);
        this.roads.accepts((FeatureVisitor)minVisitor, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)1, (int)minVisitor.getResult().toInt());
        MaxVisitor maxVisitor = new MaxVisitor((Expression)this.roadsId);
        this.roads.accepts((FeatureVisitor)maxVisitor, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)3, (int)maxVisitor.getResult().toInt());
    }

    public void testAverage() throws Exception {
        AverageVisitor averageVisitor = new AverageVisitor((Expression)this.roadsId);
        this.roads.accepts((FeatureVisitor)averageVisitor, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)2, (int)averageVisitor.getResult().toInt());
    }

    public void testUnique() throws Exception {
        UniqueVisitor uniqueVisitor = new UniqueVisitor((Expression)this.roadsId);
        this.roads.accepts((FeatureVisitor)uniqueVisitor, null);
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)3, (int)uniqueVisitor.getResult().toSet().size());
    }

    public void testSumExpression() throws Exception {
        FunctionExpression expr = (FunctionExpression)this.ff.function("Collection_Sum", new Expression[]{this.ff.property("id")});
        int result = ((Number)expr.evaluate((Object)this.roads)).intValue();
        FeatureCollectionAggregateVisitorTests.assertTrue((boolean)this.roads.isOptimized);
        FeatureCollectionAggregateVisitorTests.assertEquals((int)6, (int)result);
    }
}

