/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.attributeio;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.postgis.attributeio.Base64;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

public class PgWKBAttributeIO
implements AttributeIO {
    private boolean useByteArray;
    WKBReader wkbr;
    ByteArrayInStream inStream = new ByteArrayInStream();

    public PgWKBAttributeIO(boolean useByteArray) {
        this.useByteArray = useByteArray;
        this.wkbr = new WKBReader();
    }

    public PgWKBAttributeIO(boolean useByteArray, Hints hints) {
        this.useByteArray = useByteArray;
        GeometryFactory gf = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (gf == null) {
            Integer SRID;
            PrecisionModel pm = (PrecisionModel)hints.get((Object)Hints.JTS_PRECISION_MODEL);
            if (pm == null) {
                pm = new PrecisionModel();
            }
            int srid = (SRID = (Integer)hints.get((Object)Hints.JTS_SRID)) == null ? 0 : SRID;
            Integer dimension = (Integer)hints.get((Object)Hints.COORDINATE_DIMENSION);
            Object csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            if (csFactory == null) {
                csFactory = dimension == null || dimension <= 3 ? CoordinateArraySequenceFactory.instance() : new LiteCoordinateSequenceFactory();
            }
            gf = new GeometryFactory(pm, srid, csFactory);
        }
        this.wkbr = new WKBReader(gf);
    }

    public static byte getFromChar(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        return (byte)(c - 97 + 10);
    }

    private Geometry WKB2Geometry(byte[] wkbBytes) throws IOException {
        if (wkbBytes == null) {
            return null;
        }
        try {
            this.inStream.setBytes(wkbBytes);
            return this.wkbr.read((InStream)this.inStream);
        }
        catch (Exception e) {
            throw new DataSourceException("An exception occurred while parsing WKB data", (Throwable)e);
        }
    }

    private byte[] hexToBytes(String wkb) {
        byte[] wkbBytes = new byte[wkb.length() / 2];
        for (int i = 0; i < wkbBytes.length; ++i) {
            byte b1 = PgWKBAttributeIO.getFromChar(wkb.charAt(i * 2));
            byte b2 = PgWKBAttributeIO.getFromChar(wkb.charAt(i * 2 + 1));
            wkbBytes[i] = (byte)(b1 << 4 | b2);
        }
        return wkbBytes;
    }

    public void compare(byte[] b1, byte[] b2) {
        int len = b2.length;
        for (int t = 0; t < len; ++t) {
            if (b1[t] == b2[t]) continue;
            System.out.println("differ at position " + t + "(" + b1[t] + " vs " + b2[t] + ")");
        }
    }

    public Object read(ResultSet rs, int position) throws IOException {
        try {
            if (this.useByteArray) {
                byte[] bytes = rs.getBytes(position);
                if (bytes == null) {
                    return null;
                }
                return this.WKB2Geometry(Base64.decode(bytes));
            }
            return this.WKB2Geometry(this.hexToBytes(rs.getString(position)));
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public void write(ResultSet rs, int position, Object value) throws IOException {
        try {
            if (value == null) {
                rs.updateNull(position);
            } else {
                rs.updateBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                ps.setBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    private static class ByteArrayInStream
    implements InStream {
        byte[] buffer;
        int position;

        private ByteArrayInStream() {
        }

        public void setBytes(byte[] buffer) {
            this.buffer = buffer;
            this.position = 0;
        }

        public void read(byte[] buf) throws IOException {
            int size = buf.length;
            System.arraycopy(this.buffer, this.position, buf, 0, size);
            this.position += size;
        }
    }
}

